/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.util.builder.AbstractBuilder;

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;

/**
 * Project: Common</br> Created on: 10:44:53 PM </br>
 * 
 * @author DNS   LEV
 */
public class SiteDataBuilder extends AbstractBuilder {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6848265844475487198L;

	/**
	 * An instance of demorgraphicBuilder
	 */
	private Builder demorgraphicBuilder = null;
	
	/**
	 * An instance of eligibilityVerficationBuilder
	 */
	private Builder eligibilityVerficationBuilder = null;
	
	/**
	 * An instance of scAwardBuilder
	 */
	private Builder serviceConnectionAwardBuilder = null;
	
	/**
	 * An instance of monetaryBenefitAwardBuilder
	 */
	private Builder monetaryBenefitAwardBuilder = null;
	
	/**
	 * An instance of ineligibilityBuilder
	 */
	private Builder ineligibilityBuilder = null;
	
	/**
	 * An instance of receivedEnrollmentBuilder
	 */
	private Builder receivedEnrollmentBuilder = null;
	
	/**
	 * A default constructor
	 */
	public SiteDataBuilder() {
		super();
	}

	/** Builds a person that only contains data specific to verify a veteran's benefit
	 * 
	 * @param input A person to build
	 * @param message A message containing site dta
	 * @return A fully populated person
	 * @throws BuilderException In case of error building a person
	 */
	public Person build(Person input, HL7Message message) throws BuilderException {
		
		Person updated = input;
		try {
			// Build demographic info
			Builder builder = this.getDemorgraphicBuilder();

			Object[] inputs = new Object[]{input,message};
			builder.build( inputs );
			
			// Build eligibility verification info
			builder = this.getEligibilityVerficationBuilder();
			EligibilityVerification verification = (EligibilityVerification)builder.build( inputs );
			updated.setEligibilityVerification( verification );
					
			// Build receive enrollment info
			builder = this.getReceivedEnrollmentBuilder();
			ReceivedEnrollment enrollment = (ReceivedEnrollment)builder.build( inputs );
			updated.setReceivedEnrollment( enrollment );
			
			// Build ineligibility
			builder = this.getIneligibilityBuilder();
			IneligibilityFactor factor = (IneligibilityFactor)builder.build( inputs );
			updated.setIneligibilityFactor( factor );
			
			// Build monetary info
			builder = this.getMonetaryBenefitAwardBuilder();
			MonetaryBenefitAward benefit = (MonetaryBenefitAward)builder.build( inputs );
			updated.setMonetaryBenefitAward( benefit );
			
			// Build service connection
			builder = this.getServiceConnectionAwardBuilder();
			ServiceConnectionAward award = (ServiceConnectionAward)builder.build( inputs );
			updated.setServiceConnectionAward( award );
		}
		catch( Exception e ) {
			throw new BuilderException(" Failed to build a person", e );
		}
		return updated;
	}

	/**
	 * @return Returns the demorgraphicBuilder.
	 */
	public Builder getDemorgraphicBuilder() {
		return demorgraphicBuilder;
	}

	/**
	 * @param demorgraphicBuilder The demorgraphicBuilder to set.
	 */
	public void setDemorgraphicBuilder(Builder demorgraphicBuilder) {
		this.demorgraphicBuilder = demorgraphicBuilder;
	}

	/**
	 * @return Returns the eligibilityVerficationBuilder.
	 */
	public Builder getEligibilityVerficationBuilder() {
		return eligibilityVerficationBuilder;
	}

	/**
	 * @param eligibilityVerficationBuilder The eligibilityVerficationBuilder to set.
	 */
	public void setEligibilityVerficationBuilder(
			Builder eligibilityVerficationBuilder) {
		this.eligibilityVerficationBuilder = eligibilityVerficationBuilder;
	}

	/**
	 * @return Returns the serviceConnectionAwardBuilder.
	 */
	public Builder getServiceConnectionAwardBuilder() {
		return serviceConnectionAwardBuilder;
	}

	/**
	 * @param serviceConnectionAwardBuilder The serviceConnectionAwardBuilder to set.
	 */
	public void setServiceConnectionAwardBuilder(
			Builder serviceConnectionAwardBuilder) {
		this.serviceConnectionAwardBuilder = serviceConnectionAwardBuilder;
	}

	/**
	 * @return Returns the ineligibilityBuilder.
	 */
	public Builder getIneligibilityBuilder() {
		return ineligibilityBuilder;
	}

	/**
	 * @param ineligibilityBuilder The ineligibilityBuilder to set.
	 */
	public void setIneligibilityBuilder(Builder ineligibilityBuilder) {
		this.ineligibilityBuilder = ineligibilityBuilder;
	}

	/**
	 * @return Returns the monetaryBenefitBuilder.
	 */
	public Builder getMonetaryBenefitAwardBuilder() {
		return monetaryBenefitAwardBuilder;
	}

	/**
	 * @param monetaryBenefitBuilder The monetaryBenefitBuilder to set.
	 */
	public void setMonetaryBenefitAwardBuilder(Builder monetaryBenefitAwardBuilder) {
		this.monetaryBenefitAwardBuilder = monetaryBenefitAwardBuilder;
	}

	/**
	 * @return Returns the receivedEnrollmentBuilder.
	 */
	public Builder getReceivedEnrollmentBuilder() {
		return receivedEnrollmentBuilder;
	}

	/**
	 * @param receivedEnrollmentBuilder The receivedEnrollmentBuilder to set.
	 */
	public void setReceivedEnrollmentBuilder(Builder receivedEnrollmentBuilder) {
		this.receivedEnrollmentBuilder = receivedEnrollmentBuilder;
	}
}