package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.SSN;

import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Builds a SSN object from SSNMetaData
 * 
 * @author Rajiv Patnaik Created on Jul 22, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class SSNBuilder extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7880899279739846819L;
	
	private static final String PSEUDO_SSN_SUFFIX = "P";

	private Builder ssnTypeBuilder;

    private Builder psuedoSSNReasonBuilder;    


    public SSNBuilder()
    {
        super();
    }

    public Builder getSSNTypeBuilder()
    {
        return this.ssnTypeBuilder;
    }

    public void setSSNTypeBuilder(Builder typeBuilder)
    {
        this.ssnTypeBuilder = typeBuilder;
    }

    public SSN build(SSNMetaData metaData) throws BuilderException
    {
        SSN input = metaData.getEntity();
        SSN output = (input == null) ? new SSN() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private SSNType buildType(SSNType input, String code)
            throws BuilderException
    {
        return (SSNType) super.build(this.ssnTypeBuilder, input, code);
    }

    private boolean shouldKeep(SSN obj)
    {
        return (obj.getSsnText() != null);
    }

    private void transfer(SSN input, SSNMetaData metaData)
            throws BuilderException
    {
    	//Defect 5608- Strip off the "P" for Pseudo SSN when it comes into ESR.
    	//Since UI creates a Pseudo SSN without a "P", stripping off from the incoming
    	//message will keep the ESR data consistent.
    	String ssnText = metaData.getSSNText();
    	if(ssnText != null && ssnText.endsWith(PSEUDO_SSN_SUFFIX))
    	{
    		ssnText = ssnText.substring(0, ssnText.indexOf(PSEUDO_SSN_SUFFIX));
    	}
    	input.setSsnText(super.build(input.getSsnText(), ssnText));        
        
        input.setType(this.buildType(input.getType(), metaData.getSSNType()));

        input.setPseudoSSNReason((PseudoSSNReason) super.build(
                psuedoSSNReasonBuilder, input.getPseudoSSNReason(), metaData
                        .getPseudoSSNReason()));
    }
    
    /**
     * @return Returns the psuedoSSNReasonBuilder.
     */
    public Builder getPsuedoSSNReasonBuilder()
    {
        return psuedoSSNReasonBuilder;
    }

    /**
     * @param psuedoSSNReasonBuilder
     *            The psuedoSSNReasonBuilder to set.
     */
    public void setPsuedoSSNReasonBuilder(Builder psuedoSSNReasonBuilder)
    {
        this.psuedoSSNReasonBuilder = psuedoSSNReasonBuilder;
    }

    /**
     * @return Returns the ssnTypeBuilder.
     */
    public Builder getSsnTypeBuilder()
    {
        return ssnTypeBuilder;
    }

    /**
     * @param ssnTypeBuilder
     *            The ssnTypeBuilder to set.
     */
    public void setSsnTypeBuilder(Builder ssnTypeBuilder)
    {
        this.ssnTypeBuilder = ssnTypeBuilder;
    }
    
}