package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Builds a Relation object from a message(RelationMetaData).
 * 
 * @author Rajiv Patnaik Created on Jul 14, 2005
 *  
 */
public class RelationBuilder extends EntityBuilder
{
    private Builder genderBuilder;

	private Builder relationshipBuilder;
    
    private Builder nameBuilder;

    private Builder ssnBuilder;
    
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 7252255839837317513L;

    public RelationBuilder()
    {
        super();
    }

    protected boolean shouldKeep(Relation pRelation)
    {
        return true;
    }

    protected void transfer(Relation pRelation,
            RelationMetaData pRelationMetaData) throws BuilderException
    {
        pRelation.setDob(super.build(pRelation.getDob(), pRelationMetaData
                .getDOB()));
        pRelation.setGender((Gender) super.build(this.genderBuilder, pRelation
                .getGender(), pRelationMetaData.getGender()));
        pRelation.setName((Name) this.nameBuilder.build(pRelationMetaData.getName()));
        SSN ssn = (SSN) this.ssnBuilder.build(pRelationMetaData.getSsn());
        if(ssn != null)
        {
            pRelation.addSsn(ssn);
        }
        
        pRelation.setEndDate(super.build(pRelation.getEndDate(),
                pRelationMetaData.getEndDate()));
        pRelation.setStartDate(super.build(pRelation.getStartDate(),
                pRelationMetaData.getStartDate()));
    }

    /**
     * @return Returns the genderBuilder.
     */
    public Builder getGenderBuilder()
    {
        return genderBuilder;
    }

    /**
     * @param genderBuilder
     *            The genderBuilder to set.
     */
    public void setGenderBuilder(Builder genderBuilder)
    {
        this.genderBuilder = genderBuilder;
    }
    
    /**
     * @return Returns the relationshipBuilder.
     */
    public Builder getRelationshipBuilder()
    {
        return relationshipBuilder;
    }
    
    /**
     * @param relationshipBuilder The relationshipBuilder to set.
     */
    public void setRelationshipBuilder(Builder relationshipBuilder)
    {
        this.relationshipBuilder = relationshipBuilder;
    }
    
    /**
     * @return Returns the nameBuilder.
     */
    public Builder getNameBuilder()
    {
        return nameBuilder;
    }
    /**
     * @param nameBuilder The nameBuilder to set.
     */
    public void setNameBuilder(Builder nameBuilder)
    {
        this.nameBuilder = nameBuilder;
    }
    /**
     * @return Returns the ssnBuilder.
     */
    public Builder getSsnBuilder()
    {
        return ssnBuilder;
    }
    /**
     * @param ssnBuilder The ssnBuilder to set.
     */
    public void setSsnBuilder(Builder ssnBuilder)
    {
        this.ssnBuilder = ssnBuilder;
    }
    
    protected Relationship buildRelationship(Relationship relationship,
            String code) throws BuilderException
    {
        return (Relationship) super.build(this.relationshipBuilder,
                relationship, code);
    }    
}