/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.lookup.AlliedCountry;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.FederalAgency;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ReceivedEligibilityBuilder extends EntityBuilder
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 2179167801889596499L;

    private Builder typeBuilder;

    private Builder alliedCountryBuilder;

    private Builder federalAgencyBuilder;

    /**
     * Default constructor.
     */
    public ReceivedEligibilityBuilder()
    {
        super();
    }
    
    /**
     * @return Returns the alliedCountryBuilder.
     */
    public Builder getAlliedCountryBuilder()
    {
        return alliedCountryBuilder;
    }
    /**
     * @param alliedCountryBuilder The alliedCountryBuilder to set.
     */
    public void setAlliedCountryBuilder(Builder alliedCountryBuilder)
    {
        this.alliedCountryBuilder = alliedCountryBuilder;
    }
    /**
     * @return Returns the federalAgencyBuilder.
     */
    public Builder getFederalAgencyBuilder()
    {
        return federalAgencyBuilder;
    }
    /**
     * @param federalAgencyBuilder The federalAgencyBuilder to set.
     */
    public void setFederalAgencyBuilder(Builder federalAgencyBuilder)
    {
        this.federalAgencyBuilder = federalAgencyBuilder;
    }
    public Builder getTypeBuilder()
    {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder eligibilityTypeBuilder)
    {
        this.typeBuilder = eligibilityTypeBuilder;
    }

    public ReceivedEligibility build(ReceivedEligibilityMetaData metaData)
            throws BuilderException
    {
        ReceivedEligibility input = metaData.getEntity();
        ReceivedEligibility output = (input == null) ? new ReceivedEligibility()
                : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private EligibilityType buildType(EligibilityType input, String code)
            throws BuilderException
    {
        return (EligibilityType) super.build(this.typeBuilder, input, code);
    }

    private boolean shouldKeep(ReceivedEligibility obj)
    {
        return ((obj.getType() != null));
    }

    private void transfer(ReceivedEligibility input,
            ReceivedEligibilityMetaData metaData) throws BuilderException
    {
        input.setType(this.buildType(input.getType(), metaData.getType()));

        //Lookup the Allied Country Code first. If it fails, catch the exception and 
        //then lookup the Federal Agency
        AlliedCountry alliedCountry = (AlliedCountry) super.build(
                this.alliedCountryBuilder, input.getAlliedCountry(), metaData
                        .getAlliedCountryOrFederalAgency());
        input.setAlliedCountry(alliedCountry);

        if (alliedCountry == null)
        {
            input.setOtherFederalAgency((FederalAgency) super.build(
                    this.federalAgencyBuilder, input.getOtherFederalAgency(),
                    metaData.getAlliedCountryOrFederalAgency()));
        }
        
        input.setVoaHasAttachment(metaData.isVoaHasAttachment());
    }
}