/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.lookup.CollectionMethod;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.person.Race;

// Messaging Classess

/**
 * @author DNS   CHENJ2
 */
public class RaceBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */

	/**
     * 
     */
    private static final long serialVersionUID = 1810576038809539781L;

    private Builder raceTypeBuilder;
 
    private Builder collectionMethodBuilder;

    public Builder getCollectionMethodBuilder() {
        return collectionMethodBuilder;
    }

    public void setCollectionMethodBuilder(Builder collectionMethodBuilder) {
        this.collectionMethodBuilder = collectionMethodBuilder;
    }

    public Builder getRaceTypeBuilder() {
        return raceTypeBuilder;
    }

    public void setRaceTypeBuilder(Builder raceTypeBuilder) {
        this.raceTypeBuilder = raceTypeBuilder;
    }

    /**
     * Default contructor.
     */
    public RaceBuilder()
    {
        super();
    }

    public Race build(RaceMetaData metaData)
        throws BuilderException
    {
        Race input = metaData.getEntity();
        Race output = (input == null) ? new Race() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Race obj)
    {
        return ((obj.getRaceType() != null));
    }

    private void transfer(Race input, RaceMetaData metaData)
        throws BuilderException
    {
        input.setRaceType(
                (RaceType) super.build(this.raceTypeBuilder,
                        input.getRaceType(), metaData.getRaceType()));

        input.setCollectionMethod(
                (CollectionMethod) super.build(this.collectionMethodBuilder,
                        input.getCollectionMethod(), metaData.getCollectionMethod()));

    }
}