/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;


public class PhoneBuilder
    extends EntityBuilder
{
	private static final long serialVersionUID = 7733570818624765558L;
    
    private Builder changeSourceBuilder;
    private Builder phoneTypeBuilder;
	private Builder phoneTypeFromTelecomCodeBuilder;

    public PhoneBuilder()
    {
        super();
    }

    
    /**
     * @return Returns the changeSourceBuilder.
     */
    public Builder getChangeSourceBuilder()
    {
        return changeSourceBuilder;
    }
    /**
     * @param changeSourceBuilder The changeSourceBuilder to set.
     */
    public void setChangeSourceBuilder(Builder changeSourceBuilder)
    {
        this.changeSourceBuilder = changeSourceBuilder;
    }
    public Builder getPhoneTypeBuilder()
    {
        return this.phoneTypeBuilder;
    }

    public void setPhoneTypeBuilder(Builder typeBuilder)
    {
        this.phoneTypeBuilder = typeBuilder;
    }
    
    /**
     * @return Returns the phoneTypeFromTelecomCodeBuilder.
     */
    public Builder getPhoneTypeFromTelecomCodeBuilder()
    {
        return phoneTypeFromTelecomCodeBuilder;
    }
    /**
     * @param phoneTypeFromTelecomCodeBuilder The phoneTypeFromTelecomCodeBuilder to set.
     */
    public void setPhoneTypeFromTelecomCodeBuilder(
            Builder phoneTypeFromTelecomCodeBuilder)
    {
        this.phoneTypeFromTelecomCodeBuilder = phoneTypeFromTelecomCodeBuilder;
    }
    
    
    public Phone build(PhoneMetaData metaData) throws BuilderException
    {
        Phone input = metaData.getEntity();
        Phone output = (input == null) ? new Phone() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private PhoneType buildType(PhoneType input, String code)
        throws BuilderException
    {
        return (PhoneType)super.build(this.phoneTypeBuilder, input, code);
    }

    private boolean shouldKeep(Phone obj)
    {
        //CCR11553 for the valid phone deletion
    	if(obj.getPhoneNumber()== null && obj.getType() != null && obj.getChangeDate() != null)
        	obj.setPhoneNumber("");
        return (obj.getPhoneNumber() != null);
    }

    private void transfer(Phone input, PhoneMetaData metaData)
        throws BuilderException
    {
        input.setChangeDate(super.build(input.getChangeDate(), metaData
                .getChangeDate()));
        
        input.setSiteOfChange(super.build(input.getSiteOfChange(), metaData
                .getChangeSite()));
        
        input.setSourceOfChange(
                (PhoneSourceOfChange) super.build(this.changeSourceBuilder,
                        input.getSourceOfChange(), metaData.getChangeSource()));
        
        input.setPhoneNumber(super.build(input.getPhoneNumber(), metaData
            .getPhoneNumber()));
        
        //If type is already set in metadata(e.g Phone Number in PID-14), use type. Else look up type from telecom use code
        if(metaData.getType() != null)
        {
            input.setType(this.buildType(input.getType(), metaData.getType()));
        }else {
            input.setType((PhoneType)super.build(phoneTypeFromTelecomCodeBuilder, input.getType(), metaData.getTelecomUseCode()));
        }
    }
}