/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.financials.PatientVisitSummary;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class PatientVisitSummaryBuilder extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2894605477627662111L;

	/**
     * Default constructor.
     */
    public PatientVisitSummaryBuilder()
    {
        super();
    }

    public PatientVisitSummary build(PatientVisitSummaryMetaData metaData)
            throws BuilderException
    {
        PatientVisitSummary input = metaData.getEntity();
        PatientVisitSummary output = (input == null) ? new PatientVisitSummary()
                : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(PatientVisitSummary obj)
    {
        return ((obj.getIncomeYear() != null));
    }

    private void transfer(PatientVisitSummary input,
            PatientVisitSummaryMetaData metaData) throws BuilderException
    {
        input.setIncomeYear(super.buildYear(input.getIncomeYear(), metaData
                .getIncomeYear()));
        input.setInpatientDays(super.build(input.getInpatientDays(), metaData
                .getInpatientDays()));
        input.setLastVisitDate(super.build(input.getLastVisitDate(), metaData
                .getLastVisitDate()));
        input.setOutpatientDays(super.build(input.getOutpatientDays(), metaData
                .getOutpatientDays()));
        input.setFacilityVisited(super.build(input.getFacilityVisited(),
                metaData.getFacilityVisited()));
    }
}