/*******************************************************************************
 * Copyright  2004 EDS. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.SimpleTypeMetaData;

/**
 * @author DNS   LEV
 * Created on Jan 8, 2007
 */
public class NonNullEntityBuilderStrategy implements EntityBuilderStrategy {

	/**
	 * A default constructor 
	 */
	public NonNullEntityBuilderStrategy() {
		super();
	}

	/**
	 * @see gov.va.med.esr.common.builder.entity.EntityBuilderStrategy#shouldDelete(gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData)
	 */
	public boolean shouldDelete(AbstractDataTypeMetaData data) {
		return (data == null);
	}

	/**
	 * @see gov.va.med.esr.common.builder.entity.EntityBuilderStrategy#shouldDelete(java.lang.String)
	 */
	public boolean shouldDelete(String data) {
		return ("".equals(data));
	}

	/**
	 * @see gov.va.med.esr.common.builder.entity.EntityBuilderStrategy#shouldKeep(gov.va.med.esr.common.builder.datatype.metadata.SimpleTypeMetaData)
	 */
	public boolean shouldKeep(SimpleTypeMetaData data) {
		return ((data != null) && "".equals(data.getValue()));
	}

	/**
	 * @see gov.va.med.esr.common.builder.entity.EntityBuilderStrategy#shouldKeep(java.lang.String)
	 */
	public boolean shouldKeep(String data) {
		return (data == null);
	}

	/**
	 * @see gov.va.med.esr.common.builder.entity.EntityBuilderStrategy#shouldKeep(java.lang.Object)
	 */
	public boolean shouldKeep(Object data) {
		return (data != null);
	}
}