/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Name;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class NameBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4339018130317897353L;
	private Builder typeBuilder;

    /**
     * Default constructor.
     */
    public NameBuilder()
    {
        super();
    }

    public Builder getTypeBuilder()
    {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder)
    {
        this.typeBuilder = typeBuilder;
    }

    public Name build(NameMetaData metaData) throws BuilderException
    {
        Name input = metaData.getEntity();
        Name output = (input == null) ? new Name() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private NameType buildType(NameType input, String code)
        throws BuilderException
    {
        return (NameType)super.build(this.typeBuilder, input, code);
    }

    private boolean shouldKeep(Name obj)
    {
        return ((obj.getFamilyName() != null));
    }

    private void transfer(Name input, NameMetaData metaData)
        throws BuilderException
    {
        input.setFamilyName(super.build(input.getFamilyName(), metaData
            .getFamilyName()));
        input.setGivenName(super.build(input.getGivenName(), metaData
            .getGivenName()));
        input.setMiddleName(super.build(input.getMiddleName(), metaData
            .getMiddleName()));
        input.setPrefix(super.build(input.getPrefix(), metaData.getPrefix()));
        input.setSuffix(super.build(input.getSuffix(), metaData.getSuffix()));
        input.setType(this.buildType(input.getType(), metaData.getType()));
    }
}