/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MonetaryBenefitBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2122000693989386083L;
	private Builder typeBuilder;

    /**
     * Default constructor.
     */
    public MonetaryBenefitBuilder()
    {
        super();
    }

    public Builder getTypeBuilder()
    {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder)
    {
        this.typeBuilder = typeBuilder;
    }
    
    public MonetaryBenefit build(MonetaryBenefitMetaData metaData)
        throws BuilderException
    {
        MonetaryBenefit input = metaData.getEntity();
        MonetaryBenefit output = (input == null) ? new MonetaryBenefit()
            : input;

        output.setType(this.buildType(metaData.getType()));
        output.setMonetaryBenefitIndicator((Indicator) super.build(
                getIndicatorBuilder(), output.getMonetaryBenefitIndicator(),
                metaData.getIndicator()));
        
        return this.shouldKeep(output) ? output : null;
    }

    private MonetaryBenefitType buildType(String code) throws BuilderException
    {
        return (MonetaryBenefitType)this.typeBuilder.build(code);
    }

    private boolean shouldKeep(MonetaryBenefit obj)
    {
        return ((obj.getType() != null));
    }
}