/*******************************************************************************
 * Copyright  2004 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes
import gov.va.med.esr.common.builder.entity.metaData.MonetaryBenefitAwardMetaDataFromZEL;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MonetaryBenefitAwardBuilder extends EntityBuilder {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7222898023852297548L;

	private Builder monetaryBenefitBuilder;

	/**
	 * Default constructor.
	 */
	public MonetaryBenefitAwardBuilder() {
		super();
	}

	public Builder getMonetaryBenefitBuilder() {
		return this.monetaryBenefitBuilder;
	}

	public void setMonetaryBenefitBuilder(Builder monetaryBenefitBuilder) {
		this.monetaryBenefitBuilder = monetaryBenefitBuilder;
	}

	public MonetaryBenefitAward build(Person person, HL7Message message)
			throws BuilderException, InvalidMessageException {

		MonetaryBenefitAward award = person.getMonetaryBenefitAward();
		MonetaryBenefitAwardMetaData metaData = new MonetaryBenefitAwardMetaDataFromZEL(
				message.getZELSegment());
		metaData.setEntity(award);

		return this.build(metaData);
	}

	public MonetaryBenefitAward build(MonetaryBenefitAwardMetaData metaData)
		throws BuilderException {
		
		MonetaryBenefitAward input = metaData.getEntity();
		MonetaryBenefitAward output = (input == null) ? new MonetaryBenefitAward()	: input;
		transfer(output, metaData);
		return shouldKeep( output.getCheckAmount() ) ? output : null;
	}
	
	private MonetaryBenefit buildMonetaryBenefit(MonetaryBenefit input,
			MonetaryBenefitMetaData metaData) throws BuilderException {
		if (metaData == null) {
			return null;
		}

		metaData.setEntity(input);
		return (MonetaryBenefit) this.monetaryBenefitBuilder.build(metaData);

	}

	private void buildMonetaryBenefits(MonetaryBenefitAward input,
			MonetaryBenefitMetaData[] metaData) throws BuilderException {
		Set toAdd = new HashSet();

		for (int index = 0; index < ((metaData == null) ? 0 : metaData.length); index++) {
			this.processMonetaryBenefit(toAdd, metaData[index]);
		}

		input.removeAllMonetaryBenefits();

		for (Iterator i = toAdd.iterator(); i.hasNext();) {
			input.addMonetaryBenefit((MonetaryBenefit) i.next());
		}
	}

	private void processMonetaryBenefit(Set toAdd,
			MonetaryBenefitMetaData metaData) throws BuilderException {

		MonetaryBenefit value = this.buildMonetaryBenefit(null, metaData);

		if (value != null) {
			toAdd.add(value);
		}
	}

	private void transfer(MonetaryBenefitAward input,
			MonetaryBenefitAwardMetaData metaData) throws BuilderException {

		input.setCheckAmount(super.build(input.getCheckAmount(), metaData
				.getCheckAmount()));
		this.buildMonetaryBenefits(input, metaData.getMonetaryBenefits());
	}
}