/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.MilitaryServiceComponent;
import gov.va.med.esr.common.model.lookup.ServiceBranch;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZRD
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MilitaryServiceEpisodeBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4142081899633215646L;
	private Builder branchBuilder;
    private Builder dischargeTypeBuilder;
    private Builder militaryServiceComponentBuilder;

    /**
     * Default constructor.
     */
    public MilitaryServiceEpisodeBuilder()
    {
        super();
    }

    public Builder getBranchBuilder()
    {
        return this.branchBuilder;
    }

    public void setBranchBuilder(Builder branchBuilder)
    {
        this.branchBuilder = branchBuilder;
    }

    public Builder getDischargeTypeBuilder()
    {
        return this.dischargeTypeBuilder;
    }

    public void setDischargeTypeBuilder(Builder dischargeTypeBuilder)
    {
        this.dischargeTypeBuilder = dischargeTypeBuilder;
    }
    
    /**
     * @return Returns the militaryServiceComponentBuilder.
     */
    public Builder getMilitaryServiceComponentBuilder()
    {
        return militaryServiceComponentBuilder;
    }
    /**
     * @param militaryServiceComponentBuilder The militaryServiceComponentBuilder to set.
     */
    public void setMilitaryServiceComponentBuilder(
            Builder militaryServiceComponentBuilder)
    {
        this.militaryServiceComponentBuilder = militaryServiceComponentBuilder;
    }

    public MilitaryServiceEpisode build(MilitaryServiceEpisodeMetaData metaData)
        throws BuilderException
    {
        MilitaryServiceEpisode input = metaData.getEntity();
        MilitaryServiceEpisode output = (input == null)
            ? new MilitaryServiceEpisode()
            : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private ServiceBranch buildBranch(ServiceBranch input, String code)
        throws BuilderException
    {
        return super.shouldDelete(code) ? null : (ServiceBranch)super
            .build(this.branchBuilder, input, code);
    }

    private DischargeType buildDischargeType(DischargeType input, String code)
        throws BuilderException
    {
        return super.shouldDelete(code) ? null : (DischargeType)super
            .build(this.dischargeTypeBuilder, input, code);
    }


    private boolean shouldKeep(MilitaryServiceEpisode obj)
    {
        return ((obj.getServiceBranch() != null));
    }

    private void transfer(
        MilitaryServiceEpisode input,
        MilitaryServiceEpisodeMetaData metaData) throws BuilderException
    {
    	
        input.setDischargeType(this
            .buildDischargeType(input.getDischargeType(), metaData
                .getDischargeType()));
        input
            .setEndDate(super.build(input.getEndDate(), metaData.getEndDate()));

        input
            .setServiceBranch(this
                .buildBranch(input.getServiceBranch(), metaData
                    .getServiceBranch()));
        input.setServiceNumber(super.build(input.getServiceNumber(), metaData
            .getServiceNumber()));
        input.setStartDate(super.build(input.getStartDate(), metaData
            .getStartDate()));
        
        input.setMilitaryServiceComponent((MilitaryServiceComponent) super
                .build(militaryServiceComponentBuilder, input
                        .getMilitaryServiceComponent(), metaData
                        .getServiceComponent()));
        
    }
}