/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.MedicaidFactor;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class MedicaidFactorBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2167260939985524934L;

	/**
     * Default constructor.
     */
    public MedicaidFactorBuilder()
    {
        super();
    }

    public MedicaidFactor build(MedicaidFactorMetaData metaData)
        throws BuilderException
    {
        MedicaidFactor input = metaData.getEntity();
        MedicaidFactor output = (input == null) ? new MedicaidFactor() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(MedicaidFactor obj)
    {
        return ((obj.isEligibleForMedicaid() != null));
    }

    private void transfer(MedicaidFactor input, MedicaidFactorMetaData metaData)
        throws BuilderException
    {
        input.setEligibleForMedicaid(super
            .build(input.isEligibleForMedicaid(), metaData
                .getEligibleForMedicaid()));
        input.setLastUpdateDate(super.build(input.getLastUpdateDate(), metaData
            .getLastUpdateDate()));
    }
}