/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.lookup.InsurancePlanType;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the IN1
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class InsurancePlanBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5635341259797935651L;
	private Builder typeBuilder;

    /**
     * Default constructor.
     */
    public InsurancePlanBuilder()
    {
        super();
    }

    public Builder getTypeBuilder()
    {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder)
    {
        this.typeBuilder = typeBuilder;
    }

    public InsurancePlan build(InsurancePlanMetaData metaData)
        throws BuilderException
    {
        InsurancePlan input = metaData.getEntity();
        InsurancePlan output = (input == null) ? new InsurancePlan() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private InsurancePlanType buildType(InsurancePlanType input, String code)
        throws BuilderException
    {
        return super.shouldDelete(code) ? null : (InsurancePlanType)super
            .build(this.typeBuilder, input, code);
    }

    private boolean shouldKeep(InsurancePlan obj)
    {
        return ((obj.getPlanType() != null));
    }

    private void transfer(InsurancePlan input, InsurancePlanMetaData metaData)
        throws BuilderException
    {
        input.setPrecertificationRequired(super.build(input
            .isPrecertificationRequired(), metaData
            .getPrecertificationRequired()));
        input.setPlanType(this.buildType(input.getPlanType(), metaData
            .getType()));
    }
}