/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.IncompetenceRuling;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class IncompetenceRulingBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7811719495190753381L;

	/**
     * Default constructor.
     */
    public IncompetenceRulingBuilder()
    {
        super();
    }

    public IncompetenceRuling build(IncompetenceRulingMetaData metaData)
        throws BuilderException
    {
        IncompetenceRuling input = metaData.getEntity();
        IncompetenceRuling output = (input == null) ? new IncompetenceRuling()
            : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(IncompetenceRuling obj)
    {
        //If there is no data, don't create the record. i.e if Rated incompetent 
        //indicator is 0 but CivilRulingDate and VaRulingDate == null, don't create 
        //the record.
        return ((obj.getCivilRulingDate() != null) || (obj.getVaRulingDate() != null));
    }

    private void transfer(
        IncompetenceRuling input,
        IncompetenceRulingMetaData metaData) throws BuilderException
    {
        input.setCivilRulingDate(super
            .build(input.getCivilRulingDate(), metaData.getCivilRulingDate()));
        input.setVaRulingDate(super.build(input.getVaRulingDate(), metaData
            .getVARulingDate()));
        input.setIncompetent(super.build(input.isIncompetent(), metaData
                .getIncompetent()));
    }
}