/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

//Java Classes

//Library Classes

//Framework Classes
import java.util.Map;

import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

//Common Classes
import gov.va.med.esr.common.builder.entity.metaData.DependentMetaDataFromIVM;
import gov.va.med.esr.common.builder.entity.metaData.IncomeTestStatusMetaDataFromIVM;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;

//Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZMT
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class IncomeTestStatusBuilder
extends EntityBuilder
{
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1758184844092859866L;
	private Builder statusBuilder;
	private Builder typeBuilder;
	private Map responseStatusMap;

	/**
	 * Default constructor.
	 */
	public IncomeTestStatusBuilder()
	{
		super();
	}

	public Builder getStatusBuilder()
	{
		return this.statusBuilder;
	}

	public void setStatusBuilder(Builder statusBuilder)
	{
		this.statusBuilder = statusBuilder;
	}

	public Builder getTypeBuilder()
	{
		return this.typeBuilder;
	}

	public void setTypeBuilder(Builder typeBuilder)
	{
		this.typeBuilder = typeBuilder;
	}

	public Map getResponseStatusMap() {
		return responseStatusMap;
	}

	public void setResponseStatusMap(Map responseStatusMap) {
		this.responseStatusMap = responseStatusMap;
	}

	public IncomeTestStatus build(IncomeTestStatusMetaData metaData)
	throws BuilderException
	{    	
		IncomeTestStatus input = metaData.getEntity();
		IncomeTestStatus output = (input == null) ? new IncomeTestStatus()
		: input;

		this.transfer(output, metaData);

		return this.shouldKeep(output) ? output : null;
	}

	private MeansTestStatus buildStatus(MeansTestStatus input, String code)
	throws BuilderException
	{
		return super.shouldDelete(code) ? null : (MeansTestStatus)super
				.build(this.statusBuilder, input, code);
	}

	private IncomeTestType buildType(IncomeTestType input, String code)
	throws BuilderException
	{
		return super.shouldDelete(code) ? null : (IncomeTestType)super
				.build(this.typeBuilder, input, code);
	}

	private boolean shouldKeep(IncomeTestStatus obj)
	{
		return ((obj.getType() != null) && (obj.getStatus() != null));
	}

	private void transfer(IncomeTestStatus input,
			IncomeTestStatusMetaData metaData) throws BuilderException {
		input.setCompletedDate(super.build(input.getCompletedDate(), metaData
				.getCompletedDate()));
		input.setLastEditedDate(super.build(input.getLastEditedDate(), metaData
				.getLastEditedDate()));
		input.setType(this.buildType(input.getType(), metaData.getType()));
		if (metaData instanceof IncomeTestStatusMetaDataFromIVM) {
			String determinedStatus = (String) this.getResponseStatusMap().get(
					metaData.getDeterminedStatus());
			input.setDeterminedStatus(this.buildStatus(input
					.getDeterminedStatus(), determinedStatus));
			String status = (String) this.getResponseStatusMap().get(
					metaData.getStatus());
			input.setStatus(this.buildStatus(input.getStatus(), status));
		} else {
			input.setDeterminedStatus(this.buildStatus(input
					.getDeterminedStatus(), metaData.getDeterminedStatus()));
			input.setStatus(this.buildStatus(input.getStatus(), metaData
					.getStatus()));
		}
	}


}