/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.financials.Income;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class IncomeBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1969635419213118135L;

	/**
     * Default constructor.
     */
    public IncomeBuilder()
    {
        super();
    }

    public Income build(IncomeMetaData metaData) throws BuilderException
    {
        Income input = metaData.getEntity();
        Income output = (input == null) ? new Income() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Income obj)
    {
        return ((obj.getAmount() != null));
    }

    private void transfer(Income input, IncomeMetaData metaData)
        throws BuilderException
    {
        input.setAmount(super.build(input.getAmount(), metaData.getAmount()));
    }
}