/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * @author Martin Francisco
 */
public class ImpreciseDateIgnoringInvalidPartsBuilder
    extends AbstractBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6185879646723192503L;
	private Builder standardBuilder;

    /**
     * Default contructor.
     */
    public ImpreciseDateIgnoringInvalidPartsBuilder()
    {
        super();
    }

    public Builder getStandardBuilder()
    {
        return this.standardBuilder;
    }

    public void setStandardBuilder(Builder standardBuilder)
    {
        this.standardBuilder = standardBuilder;
    }

    public ImpreciseDate build(String value) throws BuilderException
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            try
            {
                return (ImpreciseDate)this.standardBuilder.build(value);
            }
            catch(BuilderException e)
            {
                if(value.length() > 8)
                {
                    return this.build(value.substring(0, 8));
                }
                else if(value.length() > 6)
                {
                    return this.build(value.substring(0, 6));
                }
                else if(value.length() > 4)
                {
                    return this.build(value.substring(0, 4));
                }
                else
                {
                    throw e;
                }
            }
        }
    }
}