/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.financials.Hardship;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZMT
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class HardshipBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 258565016783747174L;

	/**
     * Default constructor.
     */
    public HardshipBuilder()
    {
        super();
    }

    public Hardship build(HardshipMetaData metaData) throws BuilderException
    {
        Hardship input = metaData.getEntity();
        Hardship output = (input == null) ? new Hardship() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Hardship obj)
    {
        return ((obj.getEffectiveDate() != null)
            || (obj.getHardshipGranted() != null) || (obj.getReason() != null)
            || (obj.getReviewDate() != null) || (obj.getSiteGrantingHardship() != null));
    }

    private void transfer(Hardship input, HardshipMetaData metaData)
        throws BuilderException
    {
        input.setEffectiveDate(super.build(input.getEffectiveDate(), metaData
            .getEffectiveDate()));
        input.setHardshipGranted(super
            .build(input.getHardshipGranted(), metaData.getHardshipGranted()));
        input.setReason(super.build(input.getReason(), metaData.getReason()));
        input.setReviewDate(super.build(input.getReviewDate(), metaData
            .getReviewDate()));
        input.setSiteGrantingHardship(super.build(input
            .getSiteGrantingHardship(), metaData.getSiteGrantingHardship()));
    }
}