package gov.va.med.esr.common.builder.entity;

import java.util.Date;

import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.lookup.FeeBasisProgram;
import gov.va.med.esr.common.model.lookup.FeeBasisTreatmentType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Builds a FeeBasis onject from FeeBasisMetadata
 * 
 * @author Rajiv Patnaik
 * Created on Feb 14, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class FeeBasisBuilder extends EntityBuilder
{
    private static final long serialVersionUID = -5555496283351328973L;
    
    private Builder reportSiteBuilder;
    private Builder feeBasisProgramBuilder;
    private Builder feeBasisTreatmentTypeBuilder;
    
    public FeeBasisBuilder()
    {
        super();
    }
    
    public FeeBasis build(FeeBasisMetaData metaData) throws BuilderException
    {
        FeeBasis input = metaData.getEntity();
        FeeBasis output  = (input == null) ? new FeeBasis() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    /**
     * @return Returns the feeBasisProgramBuilder.
     */
    public Builder getFeeBasisProgramBuilder()
    {
        return feeBasisProgramBuilder;
    }
    /**
     * @param feeBasisProgramBuilder The feeBasisProgramBuilder to set.
     */
    public void setFeeBasisProgramBuilder(Builder feeBasisProgramBuilder)
    {
        this.feeBasisProgramBuilder = feeBasisProgramBuilder;
    }
    /**
     * @return Returns the feeBasisTreatmentTypeBuilder.
     */
    public Builder getFeeBasisTreatmentTypeBuilder()
    {
        return feeBasisTreatmentTypeBuilder;
    }
    /**
     * @param feeBasisTreatmentTypeBuilder The feeBasisTreatmentTypeBuilder to set.
     */
    public void setFeeBasisTreatmentTypeBuilder(
            Builder feeBasisTreatmentTypeBuilder)
    {
        this.feeBasisTreatmentTypeBuilder = feeBasisTreatmentTypeBuilder;
    }

    
    /**
     * @return Returns the reportSiteBuilder.
     */
    public Builder getReportSiteBuilder()
    {
        return reportSiteBuilder;
    }
    /**
     * @param reportSiteBuilder The reportSiteBuilder to set.
     */
    public void setReportSiteBuilder(Builder reportSiteBuilder)
    {
        this.reportSiteBuilder = reportSiteBuilder;
    }
    
    /**
     * @param output
     * @return
     */
    private boolean shouldKeep(FeeBasis input)
    {
        //Fee Basis is a required field in ZFE
        return (input.getProgram() != null);
    }

    /**
     * @param output
     * @param metaData
     * @throws BuilderException
     */
    private void transfer(FeeBasis input, FeeBasisMetaData metaData)
            throws BuilderException
    {
        input.setAuthorizationFromDate(super.build(input.getAuthorizationFromDate(), metaData
                .getAuthorizationFromDate()));
        
        input.setAuthorizationToDate(super.build(input.getAuthorizationToDate(), metaData
                .getAuthorizationToDate()));
        
        input.setProgram((FeeBasisProgram) super.build(feeBasisProgramBuilder,
                input.getProgram(), metaData.getFeeBasisProgram()));
        
        input.setReportSite((VAFacility) super.build(reportSiteBuilder,
                input.getReportSite(), metaData.getReportSite()));
        
        input.setTreatmentType((FeeBasisTreatmentType) super.build(feeBasisTreatmentTypeBuilder,
                input.getTreatmentType(), metaData.getTreatmentTypeCode()));
        
        //Set it to current date
        input.setReportDate(new Date());
        
    }
}
