/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.financials.Expense;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ExpenseBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6587297640584587510L;

	/**
     * Default constructor.
     */
    public ExpenseBuilder()
    {
        super();
    }

    public Expense build(ExpenseMetaData metaData) throws BuilderException
    {
        Expense input = metaData.getEntity();
        Expense output = (input == null) ? new Expense() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Expense obj)
    {
        return ((obj.getAmount() != null));
    }

    private void transfer(Expense input, ExpenseMetaData metaData) throws BuilderException
    {
        input.setAmount(super.build(input.getAmount(), metaData.getAmount()));
    }
}