/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.lookup.CollectionMethod;
import gov.va.med.esr.common.model.lookup.EthnicityType;
import gov.va.med.esr.common.model.person.Ethnicity;

// Messaging Classess

/**
 * @author DNS   CHENJ2
 */
public class EthnicityBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
    private static final long serialVersionUID = -8330493619951900269L;

    private Builder ethnicityTypeBuilder;
 
    private Builder collectionMethodBuilder;

    public Builder getCollectionMethodBuilder() {
        return collectionMethodBuilder;
    }

    public void setCollectionMethodBuilder(Builder collectionMethodBuilder) {
        this.collectionMethodBuilder = collectionMethodBuilder;
    }

    public Builder getEthnicityTypeBuilder() {
        return ethnicityTypeBuilder;
    }

    public void setEthnicityTypeBuilder(Builder ethnicityTypeBuilder) {
        this.ethnicityTypeBuilder = ethnicityTypeBuilder;
    }

    /**
     * Default contructor.
     */
    public EthnicityBuilder()
    {
        super();
    }

    public Ethnicity build(EthnicityMetaData metaData)
        throws BuilderException
    {
        Ethnicity input = metaData.getEntity();
        Ethnicity output = (input == null) ? new Ethnicity() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Ethnicity obj)
    {
        return ((obj.getEthnicityType() != null));
    }

    private void transfer(Ethnicity input, EthnicityMetaData metaData)
        throws BuilderException
    {
        input.setEthnicityType(
                (EthnicityType) super.build(this.ethnicityTypeBuilder,
                        input.getEthnicityType(), metaData.getEthnicityType()));

        input.setCollectionMethod(
                (CollectionMethod) super.build(this.collectionMethodBuilder,
                        input.getCollectionMethod(), metaData.getCollectionMethod()));

    }
}