/*******************************************************************************
 * Copyright  2004 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;

// Common Classes
import gov.va.med.esr.common.builder.entity.metaData.EligibilityVerificationMetaDataFromZEL;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class EligibilityVerificationBuilder extends EntityBuilder {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5273926109892693698L;

	private Builder sourceBuilder;

	private Builder eligibilityStatusBuilder;

	/**
	 * Default constructor.
	 */
	public EligibilityVerificationBuilder() {
		super();
	}

	public Builder getSourceBuilder() {
		return this.sourceBuilder;
	}

	public void setSourceBuilder(Builder sourceBuilder) {
		this.sourceBuilder = sourceBuilder;
	}

	public EligibilityVerification build( Person person, HL7Message message )
		throws BuilderException, InvalidMessageException {

		EligibilityVerification updated = person.getEligibilityVerification();
		EligibilityVerificationMetaData metaData = 
			new EligibilityVerificationMetaDataFromZEL( message.getZELSegment(), message.getMSHSegment());
		metaData.setEntity( updated );

		return this.build( metaData );
	}
	public EligibilityVerification build(EligibilityVerificationMetaData metaData)
			throws BuilderException {
		EligibilityVerification input = metaData.getEntity();
		EligibilityVerification output = (input == null) ? new EligibilityVerification()
				: input;

		this.transfer(output, metaData);

		return this.shouldKeep(output) ? output : null;
	}

	private EligibilityVerificationSource buildSource(
			EligibilityVerificationSource input, String code)
			throws BuilderException {
		return (EligibilityVerificationSource) super.build(this.sourceBuilder,
				input, code);
	}

	private boolean shouldKeep(EligibilityVerification obj) {
		return ((obj.getEligibilityStatusDate() != null));
	}

	private void transfer(EligibilityVerification input,
			EligibilityVerificationMetaData metaData) throws BuilderException {
		input.setEligibilityStatus((EligibilityStatus) super.build(
				eligibilityStatusBuilder, input.getEligibilityStatus(), metaData
						.getEligibilityStatus()));
		input.setEligibilityStatusDate(super.build(input
				.getEligibilityStatusDate(), metaData.getEligibilityStatusDate()));
		input.setVerificationFacility(super
				.build(input.getVerificationFacility(), metaData
						.getVerificationFacility()));
		input.setVerificationMethod(super.build(input.getVerificationMethod(),
				metaData.getVerificationMethod()));
		input.setVerificationSource(this.buildSource(input
				.getVerificationSource(), metaData.getVerificationSource()));
	}

	/**
	 * @return Returns the eligibilityStatusBuilder.
	 */
	public Builder getEligibilityStatusBuilder() {
		return eligibilityStatusBuilder;
	}

	/**
	 * @param eligibilityStatusBuilder
	 *           The eligibilityStatusBuilder to set.
	 */
	public void setEligibilityStatusBuilder(Builder eligibilityStatusBuilder) {
		this.eligibilityStatusBuilder = eligibilityStatusBuilder;
	}
}