package gov.va.med.esr.common.builder.entity;

import java.util.Map;

import gov.va.med.esr.common.builder.entity.metaData.DependentMetaDataFromIVM;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Builds a Dependent object from a message(DependentMetaData).
 * 
 * @author Rajiv Patnaik Created on Jul 14, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class DependentBuilder extends RelationBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6220648939876337845L;
	
	private Map responseStatusMap;

    public Map getResponseStatusMap() {
		return responseStatusMap;
	}

	public void setResponseStatusMap(Map responseStatusMap) {
		this.responseStatusMap = responseStatusMap;
	}

	public DependentBuilder()
    {
        super();
    }

    public Dependent build(DependentMetaData metaData) throws BuilderException
    {
        Dependent input = metaData.getEntity();
        Dependent output = (input == null) ? new Dependent() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Dependent dependent)
    {
        return (super.shouldKeep(dependent));
    }

    private void transfer(Dependent dependent, DependentMetaData metaData)
            throws BuilderException
    {
        super.transfer(dependent, metaData);
        
        if(metaData instanceof DependentMetaDataFromIVM ){
        	String relationship = (String)this.getResponseStatusMap().get(metaData.getRelationship());
        	dependent.setRelationship(super.buildRelationship(dependent
                    .getRelationship(), relationship));        	
        }
        else{
        	dependent.setRelationship(super.buildRelationship(dependent
                    .getRelationship(), metaData.getRelationship()));
        	
        }
    }

}