/*******************************************************************************
 * Copyright  2004 EDS. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.builder.entity;

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.RejectionRemark;

/**
 * Builds a rated disability from a message and a person if elements in the ZRD
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class DecorationBuilder extends EntityBuilder {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6872223594564186617L;

	/**
	 * Default constructor.
	 */
	public DecorationBuilder() {
		super();
	}

	private boolean shouldKeep(Decoration obj) {
		return true;
	}

	public static class PurpleHeartBuilder extends DecorationBuilder {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -4672285984211607990L;

		private Builder rejectionRemarkBuilder;

		private Builder decorationStatusBuilder;

		public PurpleHeartBuilder() {
			super();
		}

		/**
		 * @return Returns the decorationStatusBuilder.
		 */
		public Builder getDecorationStatusBuilder() {
			return decorationStatusBuilder;
		}

		/**
		 * @param decorationStatusBuilder
		 *           The decorationStatusBuilder to set.
		 */
		public void setDecorationStatusBuilder(Builder decorationStatusBuilder) {
			this.decorationStatusBuilder = decorationStatusBuilder;
		}

		public Builder getRejectionRemarkBuilder() {
			return this.rejectionRemarkBuilder;
		}

		public void setRejectionRemarkBuilder(Builder branchBuilder) {
			this.rejectionRemarkBuilder = branchBuilder;
		}

		public PurpleHeart build(PurpleHeartMetaData metaData)
				throws BuilderException {
			PurpleHeart input = metaData.getEntity();
			PurpleHeart output = (input == null) ? new PurpleHeart() : input;

			this.transfer(output, metaData);

			return this.shouldKeep(output) ? output : null;
		}

		private RejectionRemark buildRejectionRemark(RejectionRemark input,
				String code) throws BuilderException {
			return super.shouldDelete(code) ? null : (RejectionRemark) super
					.build(this.rejectionRemarkBuilder, input, code);
		}

		private boolean shouldKeep(PurpleHeart obj) {
			return (super.shouldKeep((Decoration) obj));
		}

		private void transfer(PurpleHeart input, PurpleHeartMetaData metaData) throws BuilderException {

			// ZMH^3^PH^Y~1~1^""
			
			// build rejection remark
			input.setRejectionRemark( this.buildRejectionRemark(input.getRejectionRemark(), metaData.getRejectionRemark()));

			// Added RP 07/21 - build status - 1 is pending 
			input.setStatus((DecorationStatus) super.build(decorationStatusBuilder, input.getStatus(), metaData.getStatus()));

			// Set VAFacility site - This is not from a ZMH segment but from a MSH segment
			input.setFacility(super.build(input.getFacility(), metaData.getFacility()));

			// Builds indicator Y 
			input.setPhIndicator("Y".equals(metaData.getIndicator()) ? Boolean.TRUE: Boolean.FALSE);
		}
	}
}