/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.financials.Debt;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class DebtBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8329305578431515705L;

	/**
     * Default constructor.
     */
    public DebtBuilder()
    {
        super();
    }

    public Debt build(DebtMetaData metaData) throws BuilderException
    {
        Debt input = metaData.getEntity();
        Debt output = (input == null) ? new Debt() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Debt obj)
    {
        return ((obj.getAmount() != null));
    }

    private void transfer(Debt input, DebtMetaData metaData)
        throws BuilderException
    {
        input.setAmount(super.build(input.getAmount(), metaData.getAmount()));
    }
}