/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.person.DeathRecord;

/**
 * @author Martin Francisco
 */
public class DeathRecordBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5074962329604504423L;
	private Builder deathDataSourceBuilder;

    /**
     * Default contructor.
     */
    public DeathRecordBuilder()
    {
        super();
    }

    public Builder getDeathDataSourceBuilder()
    {
        return this.deathDataSourceBuilder;
    }

    public void setDeathDataSourceBuilder(Builder dataSourceBuilder)
    {
        this.deathDataSourceBuilder = dataSourceBuilder;
    }

    public DeathRecord build(DeathRecordMetaData metaData)
        throws BuilderException
    {
        DeathRecord input = metaData.getEntity();
        DeathRecord output = (input == null) ? new DeathRecord() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private DeathDataSource buildDataSource(DeathDataSource input, String code)
        throws BuilderException
    {
        return (DeathDataSource)super
            .build(this.deathDataSourceBuilder, input, code);
    }

    private boolean shouldKeep(DeathRecord obj)
    {
        return ((obj.getDeathDate() != null) || (obj.getLazarusDate() != null));
    }

    private void transfer(DeathRecord input, DeathRecordMetaData metaData)
        throws BuilderException
    {
        input.setDataSource(this
            .buildDataSource(input.getDataSource(), metaData.getDataSource()));
        input.setDeathDate(super.build(input.getDeathDate(), metaData
            .getDeathDate()));
        input.setDeathReportDate(super
            .build(input.getDeathReportDate(), metaData.getDeathReportDate()));
        input
            .setFacilityReceived(super
                .build(input.getFacilityReceived(), metaData
                    .getFacilityReceived()));
        input.setLazarusDate(super.build(input.getLazarusDate(), metaData
            .getLazarusDate()));
    }
}