/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes
import java.util.Date;

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * @author Martin Francisco
 */
public class DateBuilder
    extends AbstractBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -373137058220865204L;
	private Builder impreciseDateBuilder;

    /**
     * Default contructor.
     */
    public DateBuilder()
    {
        super();
    }

    public Builder getImpreciseDateBuilder()
    {
        return this.impreciseDateBuilder;
    }

    public void setImpreciseDateBuilder(Builder impreciseDateBuilder)
    {
        this.impreciseDateBuilder = impreciseDateBuilder;
    }

    public Date build(String value) throws BuilderException
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            ImpreciseDate ouptut = (ImpreciseDate)this.impreciseDateBuilder
                .build(value);

            if(ouptut.getDate() == null)
            {
                throw new BuilderException("Invalid date");
            }
            else
            {
                return ouptut.getDate();
            }
        }
    }
}