/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * @author Martin Francisco
 */
public class CustomImpreciseDateBuilder
    extends ImpreciseDateBuilder
{   
   
    private static final long serialVersionUID = -7086549178305149467L;
    
    public static final String DEFAULT_DATE_FORMAT="yyyyMMDD";
    
    
    public static final int DATE_LENGTH=8;

    private String dateFormat=DEFAULT_DATE_FORMAT;
    
    private static final String LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT="yyyy";
    private static final String UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT="YYYY";    
    private static final String LOWER_CASE_MONTH_FORMAT="mm";
    private static final String UPPER_CASE_MONTH_FORMAT="MM";
    private static final String LOWER_CASE_DAY_FORMAT="dd";
    private static final String UPPER_CASE_DAY_FORMAT="DD";
    

    public String getDateFormat() {
        return dateFormat;
    }


    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }


    /**
     * Default contructor.
     */
    public CustomImpreciseDateBuilder()
    {
        super();
    }


	public ImpreciseDate build(String value) throws BuilderException
    {
        if(StringUtils.isEmpty(value))
            return null;
        if(dateFormat!=null && dateFormat.length() < DATE_LENGTH)
            throw new BuilderException(
                    "The Date format " + dateFormat + " is in an invalid imprecise date format");
        StringBuffer dateStrBuf=new StringBuffer();
        
        int yearIndex=StringUtils.indexOf(dateFormat,LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT)!=-1? 
                StringUtils.indexOf(dateFormat,LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT): StringUtils.indexOf(dateFormat,UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT);
                
        int monthIndex=StringUtils.indexOf(dateFormat,LOWER_CASE_MONTH_FORMAT)!=-1? 
                StringUtils.indexOf(dateFormat,LOWER_CASE_MONTH_FORMAT): StringUtils.indexOf(dateFormat,UPPER_CASE_MONTH_FORMAT);
  
        int dayIndex=StringUtils.indexOf(dateFormat,LOWER_CASE_DAY_FORMAT)!=-1? 
                        StringUtils.indexOf(dateFormat,LOWER_CASE_DAY_FORMAT): StringUtils.indexOf(dateFormat,UPPER_CASE_DAY_FORMAT);
        
        String yearString= yearIndex!=-1 && value.length() >=4 ? StringUtils.substring(value, yearIndex, yearIndex + LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT.length()):"";
        String monthString= monthIndex!=-1 && value.length() >= 6  ? StringUtils.substring(value, monthIndex, monthIndex + LOWER_CASE_MONTH_FORMAT.length()):"";
        String dayString= dayIndex!=-1 && value.length() >=8? StringUtils.substring(value, dayIndex, dayIndex + LOWER_CASE_DAY_FORMAT.length()):"";
        
        
        dateStrBuf.append( yearString);
        dateStrBuf.append( monthString);
        dateStrBuf.append( dayString);    
        
        return (dateStrBuf.toString().trim().length()>0) ?  super.parseString(dateStrBuf.toString().trim()) : null;
    }

   
}