/********************************************************************
 * Copyright  2006 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * @author DNS   KATIKM
 *
 */
public class CombatEpisodeBuilder extends EntityBuilder {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Builder conflictLocationBuilder;

    /**
     * Default constructor.
     */
    public CombatEpisodeBuilder()
    {
        super();
    }

    /**
	 * @return Returns the conflictBuilder.
	 */
	public Builder getConflictLocationBuilder() {
		return this.conflictLocationBuilder;
	}

	/**
	 * @param conflictBuilder The conflictBuilder to set.
	 */
	public void setConflictLocationBuilder(Builder conflictLocationBuilder) {
		this.conflictLocationBuilder = conflictLocationBuilder;
	}

	public CombatEpisode build(CombatEpisodeMetaData metaData)
        throws BuilderException
    {
    	CombatEpisode input = metaData.getEntity();
    	CombatEpisode output = (input == null) ? new CombatEpisode() : input;

    	//copy data from meta data to object
        this.transfer(output, metaData);

        //verify for minimum required data
        return this.shouldKeep(output) ? output : null;
    }
   
    private boolean shouldKeep(CombatEpisode obj)
    {
    	//Conflict location, start date and end date are required
    	if (obj.getStartDate() == null || 
    			obj.getEndDate() == null || 
    			obj.getConflictLocation() == null)
    		return false;
    	else
    		return true;
    }
    
    private ConflictLocation buildConflict(ConflictLocation input, String code)
    throws BuilderException
    {
    	return super.shouldDelete(code) ? null : (ConflictLocation)super
    			.build(this.conflictLocationBuilder, input, code);
	}    

    private void transfer(CombatEpisode input, CombatEpisodeMetaData metaData) 
    	throws BuilderException
    {
    	//dates
    	input.setEndDate(super.build(input.getEndDate(), metaData.getEndDate()));
        input.setStartDate(super.build(input.getStartDate(), metaData.getStartDate()));
        
        //combat location
        input.setConflictLocation(
            this.buildConflict(input.getConflictLocation(), metaData.getConflictLocation()));
        
        //Source is not set from messaging it is always null
        input.setOEFOIFSource(null);
        	
        //vaFacilityBuilder
        if (metaData.getFacility() != null) {
        	input.setOEFOIFStationNumber(
        		(VAFacility)getVaFacilityBuilder().build(metaData.getFacility()));
        }
    } 
}
