/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.model.ee.CatastrophicDisability;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public interface CatastrophicDisabilityMetaData
    extends ClinicalDeterminationMetaData
{
    public CatastrophicDisability getEntity();

    public void setEntity(CatastrophicDisability entity);

    public String getDeterminationDate();
    
    public String getCatastrophicallyDisabled();

    public CDConditionMetaData[] getConditions();

    public String getDeterminationMethod();

    public String getDeterminedBy();

    public CDDiagnosisMetaData[] getDiagnoses();

    public CDProcedureMetaData[] getProcedures();
    
    public CDDescriptorMetaData[] getDescriptors();

    public String getReviewDate(); 
    
    /**
     * 
     * VeteranRequestedCDReviewDate (Precise) (VISTA Messaging HL7)
     * 
     * @return String A value of VeteranRequestedCDReviewDate
     */
    public String getVeteranRequestedCDReviewDate();
    
    /**
     * 
     * Date facility initiated review (Precise) (VISTA Messaging HL7)
     * 
     * @return String A value of FacilityInitiatedCDReviewDate
     */
    public String getFacilityInitiatedCDReviewDate();
    
    /**
     * 
     * Date Veteran was notified (Precise) (VISTA Messaging HL7)
     * 
     * @return String A value of VeteranWasNotifiedCDDate
     */
    public String getVeteranWasNotifiedCDDate();    
        
}