/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.lookup.CancelDeclineNotProcessedReason;
import gov.va.med.esr.common.model.lookup.CancelDeclineReason;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class CancelDeclineBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4897681510777572910L;
	private Builder reasonBuilder;
    private Builder reasonNotProcessedBuilder;

    /**
     * Default constructor.
     */
    public CancelDeclineBuilder()
    {
        super();
    }

    public Builder getReasonBuilder()
    {
        return this.reasonBuilder;
    }

    public void setReasonBuilder(Builder reasonBuilder)
    {
        this.reasonBuilder = reasonBuilder;
    }

    public Builder getReasonNotProcessedBuilder()
    {
        return this.reasonNotProcessedBuilder;
    }

    public void setReasonNotProcessedBuilder(Builder reasonNotProcessedBuilder)
    {
        this.reasonNotProcessedBuilder = reasonNotProcessedBuilder;
    }

    public CancelDecline build(CancelDeclineMetaData metaData)
        throws BuilderException
    {
        CancelDecline input = metaData.getEntity();
        CancelDecline output = (input == null) ? new CancelDecline() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private CancelDeclineReason buildReason(
        CancelDeclineReason input,
        String code) throws BuilderException
    {
        return (CancelDeclineReason)super
            .build(this.reasonBuilder, input, code);
    }

    private CancelDeclineNotProcessedReason buildReasonNotProcessed(
        CancelDeclineNotProcessedReason input,
        String code) throws BuilderException
    {
        return (CancelDeclineNotProcessedReason)super
            .build(this.reasonNotProcessedBuilder, input, code);
    }

    private boolean shouldKeep(CancelDecline obj)
    {
        return ((obj.getEffectiveDate() != null) && (obj.getReason() != null));
    }

    private void transfer(CancelDecline input, CancelDeclineMetaData metaData)
        throws BuilderException
    {
        input.setEffectiveDate(super.build(input.getEffectiveDate(), metaData
            .getEffectiveDate()));
        input.setReason(this.buildReason(input.getReason(), metaData
            .getReason()));
        input.setReasonNotProcessed(this.buildReasonNotProcessed(input
            .getReasonNotProcessed(), metaData.getReasonNotProcessed()));
        input
            .setRemarks(super.build(input.getRemarks(), metaData.getRemarks()));
    }
}