/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.lookup.AffectedExtremity;
import gov.va.med.esr.common.model.lookup.Procedure;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZRD
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class CDProcedureBuilder extends EntityBuilder
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -5198976636672765880L;

    private Builder affectedExtremityBuilder;

    private Builder procedureBuilder;

    /**
     * Default constructor.
     */
    public CDProcedureBuilder()
    {
        super();
    }

    public Builder getAffectedExtremityBuilder()
    {
        return this.affectedExtremityBuilder;
    }

    public void setAffectedExtremityBuilder(Builder affectedExtremityBuilder)
    {
        this.affectedExtremityBuilder = affectedExtremityBuilder;
    }

    public Builder getProcedureBuilder()
    {
        return this.procedureBuilder;
    }

    public void setProcedureBuilder(Builder procedureBuilder)
    {
        this.procedureBuilder = procedureBuilder;
    }

    public CDProcedure build(CDProcedureMetaData metaData)
            throws BuilderException
    {
        CDProcedure input = metaData.getEntity();
        CDProcedure output = (input == null) ? new CDProcedure() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private AffectedExtremity buildAffectedExtremity(AffectedExtremity input,
            String code) throws BuilderException
    {
        return super.shouldDelete(code) ? null : (AffectedExtremity) super
                .build(this.affectedExtremityBuilder, input, code);
    }

    private Procedure buildProcedure(Procedure input, String code)
            throws BuilderException
    {
        return super.shouldDelete(code) ? null : (Procedure) super.build(
                this.procedureBuilder, input, code);
    }

    private boolean shouldKeep(CDProcedure obj)
    {
        return ((obj.getAffectedExtremity() != null) && (obj.getProcedure() != null));
    }

    private void transfer(CDProcedure input, CDProcedureMetaData metaData)
            throws BuilderException
    {
        input.setAffectedExtremity(this.buildAffectedExtremity(input
                .getAffectedExtremity(), metaData.getAffectedExtremity()));
        input.setProcedure(this.buildProcedure(input.getProcedure(), metaData
                .getProcedure()));
    }
}