/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.lookup.Diagnosis;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZRD
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class CDDiagnosisBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 151574486057812146L;
	private Builder diagnosisBuilder;

    /**
     * Default constructor.
     */
    public CDDiagnosisBuilder()
    {
        super();
    }

    public Builder getDiagnosisBuilder()
    {
        return this.diagnosisBuilder;
    }

    public void setDiagnosisBuilder(Builder diagnosisBuilder)
    {
        this.diagnosisBuilder = diagnosisBuilder;
    }

    public CDDiagnosis build(CDDiagnosisMetaData metaData)
        throws BuilderException
    {
        CDDiagnosis input = metaData.getEntity();
        CDDiagnosis output = (input == null) ? new CDDiagnosis() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private Diagnosis buildDiagnosis(Diagnosis input, String code)
        throws BuilderException
    {
        return super.shouldDelete(code) ? null : (Diagnosis)super
            .build(this.diagnosisBuilder, input, code);
    }

    private boolean shouldKeep(CDDiagnosis obj)
    {
        return ((obj.getDiagnosis() != null));
    }

    private void transfer(CDDiagnosis input, CDDiagnosisMetaData metaData)
        throws BuilderException
    {
        input.setDiagnosis(this.buildDiagnosis(input.getDiagnosis(), metaData
            .getDiagnosis()));
    }
}