/********************************************************************
 * Copyright  2014 HP All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes

import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.lookup.DescriptorType;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZRD
 * segments are present
 * 
 * @author DNS   zhangs
 * @version 1.0
 */
public class CDDescriptorBuilder
    extends EntityBuilder 
{
    /**
     * 
     */
    private static final long serialVersionUID = -2570478030476816699L;
    /**
     * An instance of serialVersionUID
     */
   
    private Builder descriptorBuilder;

    /**
     * Default constructor.
     */
    public CDDescriptorBuilder()
    {
        super();
    }

    public Builder getDescriptorBuilder()
    {
        return this.descriptorBuilder;
    }

    public void setDescriptorBuilder(Builder descriptorBuilder)
    {
        this.descriptorBuilder = descriptorBuilder;
    }

    public CDDescriptor build(CDDescriptorMetaData metaData)
        throws BuilderException
    {
        CDDescriptor input = metaData.getEntity();
        CDDescriptor output = (input == null) ? new CDDescriptor() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private DescriptorType buildDescriptor(DescriptorType input, String code)
        throws BuilderException
    {
        return super.shouldDelete(code) ? null : (DescriptorType)super   
            .build(this.descriptorBuilder, input, code);
    }

    private boolean shouldKeep(CDDescriptor obj)
    {
        return ((obj.getDescriptorType() != null));
    }

    private void transfer(CDDescriptor input, CDDescriptorMetaData metaData)
        throws BuilderException
    {
        input.setDescriptorType(this.buildDescriptor(input.getDescriptorType(), metaData  
            .getDescriptor()));
    }
}