/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.lookup.Condition;
import gov.va.med.esr.common.model.lookup.PermanentIndicator;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZRD
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class CDConditionBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6925301238389981107L;
	private Builder conditionBuilder;

    /**
     * Default constructor.
     */
    public CDConditionBuilder()
    {
        super();
    }

    public Builder getConditionBuilder()
    {
        return this.conditionBuilder;
    }

    public void setConditionBuilder(Builder conditionBuilder)
    {
        this.conditionBuilder = conditionBuilder;
    }

    public CDCondition build(CDConditionMetaData metaData)
        throws BuilderException
    {
        CDCondition input = metaData.getEntity();
        CDCondition output = (input == null) ? new CDCondition() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(CDCondition obj)
    {
        return ((obj.getCondition() != null));
    }

    private void transfer(CDCondition input, CDConditionMetaData metaData)
        throws BuilderException
    {
        input.setCondition((Condition)super.build(conditionBuilder, input.getCondition(), metaData
            .getCondition()));
        input.setPermanentIndicator((PermanentIndicator)super.build(gePermanentIndicatorBuilder(), 
                input.getPermanentIndicator(), metaData.getPermanent()));
        input.setScore(super.build(input.getScore(), metaData.getScore()));
    }
}