/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes

/**
 * @author Martin Francisco
 */
public class BooleanBuilder
    extends AbstractBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6052828153505100624L;

	/**
     * Default contructor.
     */
    public BooleanBuilder()
    {
        super();
    }

    public Boolean build(String value) throws BuilderException
    {
        return ("Y".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) ? Boolean.TRUE
            : (("N".equalsIgnoreCase(value) || "U".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) ? Boolean.FALSE
                : null); 
    }
}