/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.person.BirthRecord;

// Messaging Classess

/**
 * @author Martin Francisco
 */
public class BirthRecordBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2124269416666923708L;

	/**
     * Default contructor.
     */
    public BirthRecordBuilder()
    {
        super();
    }

    public BirthRecord build(BirthRecordMetaData metaData)
        throws BuilderException
    {
        BirthRecord input = metaData.getEntity();
        BirthRecord output = (input == null) ? new BirthRecord() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(BirthRecord obj)
    {
        return ((obj.getBirthDate() != null));
    }

    private void transfer(BirthRecord input, BirthRecordMetaData metaData)
        throws BuilderException
    {
        input.setBirthDate(super.build(input.getBirthDate(), metaData
            .getBirthDate()));
         input.setMultipleBirth(super.build(input.getMultipleBirth(), metaData.getMultipleBirth()));
    }
}