/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;

// Messaging Classes

/**
 * Builds a rated disability from a message and a person if elements in the ZMT
 * segments are present
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class BeneficiaryTravelBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1468774349547091091L;

	/**
     * Default constructor.
     */
    public BeneficiaryTravelBuilder()
    {
        super();
    }

    public BeneficiaryTravel build(BeneficiaryTravelMetaData metaData)
        throws BuilderException
    {
        BeneficiaryTravel input = metaData.getEntity();
        BeneficiaryTravel output = (input == null)
            ? new BeneficiaryTravel()
            : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(BeneficiaryTravel obj)
    {
        return ((obj.getAmountCertified() != null)
            || (obj.getClaimDate() != null) || (obj.getDateCertified() != null) || (obj
            .isEligible() != null));
    }

    private void transfer(
        BeneficiaryTravel input,
        BeneficiaryTravelMetaData metaData) throws BuilderException
    {
        input.setAmountCertified(super
            .build(input.getAmountCertified(), metaData.getAmountCertified()));
        input.setClaimDate(super.build(input.getClaimDate(), metaData
            .getClaimDate()));
        input.setDateCertified(super.build(input.getDateCertified(), metaData
            .getDateCertified()));
        input.setEligible(super.build(input.isEligible(), metaData
            .getEligible()));
    }
}