package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.model.lookup.SensitivityChangeSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * 
 * @author Rajiv Patnaik Created on Jul 18, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class BeneficiaryBuilder extends EntityBuilder
{
    private Builder sensitivityChangeSourceBuilder;
    
    /**
     * @return Returns the sensitivityChangeSourceBuilder.
     */
    public Builder getSensitivityChangeSourceBuilder()
    {
        return sensitivityChangeSourceBuilder;
    }
    /**
     * @param sensitivityChangeSourceBuilder The sensitivityChangeSourceBuilder to set.
     */
    public void setSensitivityChangeSourceBuilder(
            Builder sensitivityChangeSourceBuilder)
    {
        this.sensitivityChangeSourceBuilder = sensitivityChangeSourceBuilder;
    }
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7744115663361444515L;

	public BeneficiaryBuilder()
    {
        super();
    }

    public Person build(BeneficiaryMetaData metaData) throws BuilderException
    {
        Person input = metaData.getEntity();
        Person output = (input == null) ? new Person() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Person obj)
    {
        return true;
    }

    private void transfer(Person input, BeneficiaryMetaData metaData)
            throws BuilderException
    {
        //Conditions
        //If received a claim folder number and no claim location, set the
        // location to 376.
        //If received a BAD location, set the location to blank
        String claimFolderNumberFromMsg = metaData.getClaimFolderNumber();
        input.setClaimFolderNumber(super.build(input.getClaimFolderNumber(),
                claimFolderNumberFromMsg));

        String claimFolderLocationFromMsg = metaData.getClaimFolderLocation();
        //If received a claim folder number
        if (claimFolderNumberFromMsg != null
                && claimFolderNumberFromMsg.length() > 0)
        {
            //If no claim location in msg
            if (claimFolderLocationFromMsg == null
                    || claimFolderLocationFromMsg.length() == 0)
            {
                input.setClaimFolderLocation(super
                        .build(input.getClaimFolderLocation(),
                                VAFacility.CODE_DEFAULT_CLAIM_FOLDER_LOCATION
                                        .getName()));
            }
        }
        //If claim location in msg
        if (claimFolderLocationFromMsg != null)
        {
            try
            {
                input.setClaimFolderLocation(super.build(input
                        .getClaimFolderLocation(), metaData
                        .getClaimFolderLocation()));
            } catch (BuilderException e)
            {
                //According to the requirements documents, VistA is
                // supposed to
                //implement some consistency checks to prevent erroneous
                // entry
                //of the claim folder location. In the AE/CC spreadsheet
                //instructions are not to upload any information if the
                // claim
                //folder location is invalid. So set the value to null
                //if we are not able to find the ClaimFolderLocation
                input.setClaimFolderLocation(null);
            }
        }

        input.setSensitiveRecord(super.build(input.isSensitiveRecord(),
                metaData.getSensitiveRecord()));
        input.setSensitivityChangeDate(super.build(input
                .getSensitivityChangeDate(), metaData.getSensitivityChangeDate()));
        
        if(input.getSensitiveRecord() != null)
        {
            input.setSensitivityChangeSite(super.build(input.getSensitivityChangeSite(), metaData.getSensitivityChangeSite()));
            input.setSensitivityChangeSource((SensitivityChangeSource)sensitivityChangeSourceBuilder.build(SensitivityChangeSource.CODE_VAMC.getCode()));
        }
        input.setUserEnrolleeSite(super.build(input.getUserEnrolleeSite(),
                metaData.getUserEnrolleeSite()));
        input.setUserEnrolleeValidThrough(super.buildYear(input
                .getUserEnrolleeValidThrough(), metaData
                .getUserEnrolleeValidThrough()));
    }

}