/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.financials.Asset;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class AssetBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 718855556570513424L;

	/**
     * Default constructor.
     */
    public AssetBuilder()
    {
        super();
    }

    public Asset build(AssetMetaData metaData) throws BuilderException
    {
        Asset input = metaData.getEntity();
        Asset output = (input == null) ? new Asset() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Asset obj)
    {
        return ((obj.getAmount() != null));
    }

    private void transfer(Asset input, AssetMetaData metaData)
        throws BuilderException
    {
        input.setAmount(super.build(input.getAmount(), metaData.getAmount()));
    }
}