/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes
import gov.va.med.esr.common.model.ee.Application;

// Messaging Classess

/**
 * Class that builds the application from a message.
 * 
 * @author Carlos Ruiz
 * @version 1.0
 */
public class ApplicationBuilder
    extends EntityBuilder
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4956534491159106345L;

	/**
     * Default constructor.
     */
    public ApplicationBuilder()
    {
        super();
    }

    public Application build(ApplicationMetaData metaData)
        throws BuilderException
    {
        Application input = metaData.getEntity();
        Application output = (input == null) ? new Application() : input;

        this.transfer(output, metaData);

        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Application obj)
    {
        return ((obj.getApplicationDate() != null));
    }

    public void transfer(Application input, ApplicationMetaData metaData)
        throws BuilderException
    {
        input.setApplicationDate(super
            .build(input.getApplicationDate(), metaData.getApplicationDate()));
    }
}