/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class XTN
    extends ComplexTypeMetaData
{
    private static final int POSITION_NUMBER = 0;
    private static final int POSITION_USE_CODE = 1;
    private static final int POSITION_EQUIPMENT_TYPE_CODE = 2;
    private static final int POSITION_EMAIL_ADDRESS = 3;
    private static final int POSITION_COUNTRY_CODE = 4;
    private static final int POSITION_AREA_CODE = 5;
    private static final int POSITION_PHONE_NUMBER = 6;
    private static final int POSITION_EXTENSION = 7;
    private static final int POSITION_ANY_TEXT = 8;
    private static final int DATA_SIZE = 9;

    public static XTN[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            XTN[] elements = new XTN[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = XTN.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static XTN create()
    {
        return new XTN(new AbstractDataTypeMetaData[XTN.DATA_SIZE]);
    }

    public static XTN create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[XTN.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
            int size = (components == null) ? 0 : components.length;

            data[XTN.POSITION_NUMBER] = (size > XTN.POSITION_NUMBER) ? ST
                .create(components[XTN.POSITION_NUMBER]) : null;
            data[XTN.POSITION_USE_CODE] = (size > XTN.POSITION_USE_CODE) ? ID
                .create(components[XTN.POSITION_USE_CODE]) : null;
            data[XTN.POSITION_EQUIPMENT_TYPE_CODE] = (size > XTN.POSITION_EQUIPMENT_TYPE_CODE) ? ID
                .create(components[XTN.POSITION_EQUIPMENT_TYPE_CODE])
                : null;
            data[XTN.POSITION_EMAIL_ADDRESS] = (size > XTN.POSITION_EMAIL_ADDRESS) ? ST
                .create(components[XTN.POSITION_EMAIL_ADDRESS])
                : null;
            data[XTN.POSITION_COUNTRY_CODE] = (size > XTN.POSITION_COUNTRY_CODE) ? NM
                .create(components[XTN.POSITION_COUNTRY_CODE])
                : null;
            data[XTN.POSITION_AREA_CODE] = (size > XTN.POSITION_AREA_CODE) ? NM
                .create(components[XTN.POSITION_AREA_CODE]) : null;
            data[XTN.POSITION_PHONE_NUMBER] = (size > XTN.POSITION_PHONE_NUMBER) ? NM
                .create(components[XTN.POSITION_PHONE_NUMBER])
                : null;
            data[XTN.POSITION_EXTENSION] = (size > XTN.POSITION_EXTENSION) ? NM
                .create(components[XTN.POSITION_EXTENSION]) : null;
            data[XTN.POSITION_ANY_TEXT] = (size > XTN.POSITION_ANY_TEXT) ? ST
                .create(components[XTN.POSITION_ANY_TEXT]) : null;

            return new XTN(data);
        }
    }

    public static String getDataString(
        XTN[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            delimiter, null);
    }

    XTN(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getNumber()
    {
        return (ST)super.getData(XTN.POSITION_NUMBER);
    }

    /**
     * Component 1
     */
    public void setNumber(ST number)
    {
        super.setData(XTN.POSITION_NUMBER, number);
    }

    /**
     * Component 2
     */
    public ID getUseCode()
    {
        return (ID)super.getData(XTN.POSITION_USE_CODE);
    }

    /**
     * Component 2
     */
    public void setUseCode(ID useCode)
    {
        super.setData(XTN.POSITION_USE_CODE, useCode);
    }

    /**
     * Component 3
     */
    public ID getEquipmentTypeCode()
    {
        return (ID)super.getData(XTN.POSITION_EQUIPMENT_TYPE_CODE);
    }

    /**
     * Component 3
     */
    public void setEquipmentTypeCode(ID equipmentTypeCode)
    {
        super.setData(XTN.POSITION_EQUIPMENT_TYPE_CODE, equipmentTypeCode);
    }

    /**
     * Component 4
     */
    public ST getEmailAddress()
    {
        return (ST)super.getData(XTN.POSITION_EMAIL_ADDRESS);
    }

    /**
     * Component 4
     */
    public void setEmailAddress(ST emailAddress)
    {
        super.setData(XTN.POSITION_EMAIL_ADDRESS, emailAddress);
    }

    /**
     * Component 5
     */
    public NM getCountryCode()
    {
        return (NM)super.getData(XTN.POSITION_COUNTRY_CODE);
    }

    /**
     * Component 5
     */
    public void setCountryCode(NM countryCode)
    {
        super.setData(XTN.POSITION_COUNTRY_CODE, countryCode);
    }

    /**
     * Component 6
     */
    public NM getAreaCode()
    {
        return (NM)super.getData(XTN.POSITION_AREA_CODE);
    }

    /**
     * Component 6
     */
    public void setAreaCode(NM areaCode)
    {
        super.setData(XTN.POSITION_AREA_CODE, areaCode);
    }

    /**
     * Component 7
     */
    public NM getPhoneNumber()
    {
        return (NM)super.getData(XTN.POSITION_PHONE_NUMBER);
    }

    /**
     * Component 7
     */
    public void setPhoneNumber(NM phoneNumber)
    {
        super.setData(XTN.POSITION_PHONE_NUMBER, phoneNumber);
    }

    /**
     * Component 8
     */
    public NM getExtension()
    {
        return (NM)super.getData(XTN.POSITION_EXTENSION);
    }

    /**
     * Component 8
     */
    public void setExtension(NM extension)
    {
        super.setData(XTN.POSITION_EXTENSION, extension);
    }

    /**
     * Component 9
     */
    public ST getAnyText()
    {
        return (ST)super.getData(XTN.POSITION_ANY_TEXT);
    }

    /**
     * Component 9
     */
    public void setAnyText(ST anyText)
    {
        super.setData(XTN.POSITION_ANY_TEXT, anyText);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}