/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class XPN
    extends ComplexTypeMetaData
{
    private static final int POSITION_FAMILY_NAME = 0;
    private static final int POSITION_GIVEN_NAME = 1;
    private static final int POSITION_MIDDLE_NAME = 2;
    private static final int POSITION_SUFFIX = 3;
    private static final int POSITION_PREFIX = 4;
    private static final int POSITION_DEGREE = 5;
    private static final int POSITION_TYPE_CODE = 6;
    private static final int POSITION_REPRESENTATION_CODE = 7;
    private static final int DATA_SIZE = 8;

    public static XPN[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            XPN[] elements = new XPN[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = XPN.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static XPN create()
    {
        return new XPN(new AbstractDataTypeMetaData[XPN.DATA_SIZE]);
    }

    public static XPN create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[XPN.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
            int size = (components == null) ? 0 : components.length;

            data[XPN.POSITION_FAMILY_NAME] = (size > XPN.POSITION_FAMILY_NAME) ? ST
                .create(components[XPN.POSITION_FAMILY_NAME])
                : null;
            data[XPN.POSITION_GIVEN_NAME] = (size > XPN.POSITION_GIVEN_NAME) ? ST
                .create(components[XPN.POSITION_GIVEN_NAME])
                : null;
            data[XPN.POSITION_MIDDLE_NAME] = (size > XPN.POSITION_MIDDLE_NAME) ? ST
                .create(components[XPN.POSITION_MIDDLE_NAME])
                : null;
            data[XPN.POSITION_SUFFIX] = (size > XPN.POSITION_SUFFIX) ? ST
                .create(components[XPN.POSITION_SUFFIX]) : null;
            data[XPN.POSITION_PREFIX] = (size > XPN.POSITION_PREFIX) ? ST
                .create(components[XPN.POSITION_PREFIX]) : null;
            data[XPN.POSITION_DEGREE] = (size > XPN.POSITION_DEGREE) ? IS
                .create(components[XPN.POSITION_DEGREE]) : null;
            data[XPN.POSITION_TYPE_CODE] = (size > XPN.POSITION_TYPE_CODE) ? ID
                .create(components[XPN.POSITION_TYPE_CODE]) : null;
            data[XPN.POSITION_REPRESENTATION_CODE] = (size > XPN.POSITION_REPRESENTATION_CODE) ? ID
                .create(components[XPN.POSITION_REPRESENTATION_CODE])
                : null;

            return new XPN(data);
        }
    }

    public static String getDataString(
        XPN[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            delimiter, null);
    }

    XPN(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getFamilyName()
    {
        return (ST)super.getData(XPN.POSITION_FAMILY_NAME);
    }

    /**
     * Component 1
     */
    public void setFamilyName(ST familyName)
    {
        super.setData(XPN.POSITION_FAMILY_NAME, familyName);
    }

    /**
     * Component 2
     */
    public ST getGivenName()
    {
        return (ST)super.getData(XPN.POSITION_GIVEN_NAME);
    }

    /**
     * Component 2
     */
    public void setGivenName(ST givenName)
    {
        super.setData(XPN.POSITION_GIVEN_NAME, givenName);
    }

    /**
     * Component 3
     */
    public ST getMiddleName()
    {
        return (ST)super.getData(XPN.POSITION_MIDDLE_NAME);
    }

    /**
     * Component 3
     */
    public void setMiddleName(ST middleName)
    {
        super.setData(XPN.POSITION_MIDDLE_NAME, middleName);
    }

    /**
     * Component 4
     */
    public ST getSuffix()
    {
        return (ST)super.getData(XPN.POSITION_SUFFIX);
    }

    /**
     * Component 4
     */
    public void setSuffix(ST suffix)
    {
        super.setData(XPN.POSITION_SUFFIX, suffix);
    }

    /**
     * Component 5
     */
    public ST getPrefix()
    {
        return (ST)super.getData(XPN.POSITION_PREFIX);
    }

    /**
     * Component 5
     */
    public void setPrefix(ST prefix)
    {
        super.setData(XPN.POSITION_PREFIX, prefix);
    }

    /**
     * Component 6
     */
    public IS getDegree()
    {
        return (IS)super.getData(XPN.POSITION_DEGREE);
    }

    /**
     * Component 6
     */
    public void setDegree(IS degree)
    {
        super.setData(XPN.POSITION_DEGREE, degree);
    }

    /**
     * Component 7
     */
    public ID getTypeCode()
    {
        return (ID)super.getData(XPN.POSITION_TYPE_CODE);
    }

    /**
     * Component 7
     */
    public void setTypeCode(ID typeCode)
    {
        super.setData(XPN.POSITION_TYPE_CODE, typeCode);
    }

    /**
     * Component 8
     */
    public ID getRepresentationCode()
    {
        return (ID)super.getData(XPN.POSITION_REPRESENTATION_CODE);
    }

    /**
     * Component 8
     */
    public void setRepresentationCode(ID representationCode)
    {
        super.setData(XPN.POSITION_REPRESENTATION_CODE, representationCode);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}