/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class XON
    extends ComplexTypeMetaData
{
    private static final int POSITION_ORGANIZATION_NAME = 0;
    private static final int POSITION_ORGANIZATION_NAME_TYPE_CODE = 1;
    private static final int POSITION_ID = 2;
    private static final int POSITION_ID_CHECK_DIGIT = 3;
    private static final int POSITION_ID_CHECK_DIGIT_SCHEME_CODE = 4;
    private static final int POSITION_ASSIGNING_AUTHORITY = 5;
    private static final int POSITION_ID_TYPE_CODE = 6;
    private static final int POSITION_ASSIGNING_FACILITY = 7;
    private static final int POSITION_REPRESENTATION_CODE = 8;
    private static final int DATA_SIZE = 9;

    public static XON[] create(
        String value,
        String repeatDelimiter,
        String delimiter,
        String subDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData
                .splitData(value, repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            XON[] elements = new XON[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = XON
                    .create(components[index], delimiter, subDelimiter);
            }

            return elements;
        }
    }

    public static XON create()
    {
        return new XON(new AbstractDataTypeMetaData[XON.DATA_SIZE]);
    }

    public static XON create(String value, String delimiter, String subDelimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[XON.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData
                .splitData(value, delimiter);
            int size = (components == null) ? 0 : components.length;

            data[XON.POSITION_ORGANIZATION_NAME] = (size > XON.POSITION_ORGANIZATION_NAME) ? ST
                .create(components[XON.POSITION_ORGANIZATION_NAME])
                : null;
            data[XON.POSITION_ORGANIZATION_NAME_TYPE_CODE] = (size > XON.POSITION_ORGANIZATION_NAME_TYPE_CODE) ? IS
                .create(components[XON.POSITION_ORGANIZATION_NAME_TYPE_CODE])
                : null;
            data[XON.POSITION_ID] = (size > XON.POSITION_ID) ? NM
                .create(components[XON.POSITION_ID]) : null;
            data[XON.POSITION_ID_CHECK_DIGIT] = (size > XON.POSITION_ID_CHECK_DIGIT) ? NM
                .create(components[XON.POSITION_ID_CHECK_DIGIT])
                : null;
            data[XON.POSITION_ID_CHECK_DIGIT_SCHEME_CODE] = (size > XON.POSITION_ID_CHECK_DIGIT_SCHEME_CODE) ? ID
                .create(components[XON.POSITION_ID_CHECK_DIGIT_SCHEME_CODE])
                : null;
            data[XON.POSITION_ASSIGNING_AUTHORITY] = (size > XON.POSITION_ASSIGNING_AUTHORITY) ? HD
                .create(components[XON.POSITION_ASSIGNING_AUTHORITY], subDelimiter)
                : null;
            data[XON.POSITION_ID_TYPE_CODE] = (size > XON.POSITION_ID_TYPE_CODE) ? IS
                .create(components[XON.POSITION_ID_TYPE_CODE])
                : null;
            data[XON.POSITION_ASSIGNING_FACILITY] = (size > XON.POSITION_ASSIGNING_FACILITY) ? HD
                .create(components[XON.POSITION_ASSIGNING_FACILITY], subDelimiter)
                : null;
            data[XON.POSITION_REPRESENTATION_CODE] = (size > XON.POSITION_REPRESENTATION_CODE) ? ID
                .create(components[XON.POSITION_REPRESENTATION_CODE])
                : null;

            return new XON(data);
        }
    }

    public static String getDataString(
        XON[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData
            .formatDataString(data, repeatDelimiter, delimiter, null);
    }

    XON(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getOrganizationName()
    {
        return (ST)super.getData(XON.POSITION_ORGANIZATION_NAME);
    }

    /**
     * Component 1
     */
    public void setOrganizationName(ST organizationName)
    {
        super.setData(XON.POSITION_ORGANIZATION_NAME, organizationName);
    }

    /**
     * Component 2
     */
    public IS getGivenName()
    {
        return (IS)super.getData(XON.POSITION_ORGANIZATION_NAME_TYPE_CODE);
    }

    /**
     * Component 2
     */
    public void setGivenName(IS organizationNameTypeCode)
    {
        super
            .setData(XON.POSITION_ORGANIZATION_NAME_TYPE_CODE, organizationNameTypeCode);
    }

    /**
     * Component 3
     */
    public NM getID()
    {
        return (NM)super.getData(XON.POSITION_ID);
    }

    /**
     * Component 3
     */
    public void setID(NM id)
    {
        super.setData(XON.POSITION_ID, id);
    }

    /**
     * Component 4
     */
    public NM getIDCheckDigit()
    {
        return (NM)super.getData(XON.POSITION_ID_CHECK_DIGIT);
    }

    /**
     * Component 4
     */
    public void setIDCheckDigit(NM idCheckDigit)
    {
        super.setData(XON.POSITION_ID_CHECK_DIGIT, idCheckDigit);
    }

    /**
     * Component 5
     */
    public ID getIDCheckDigitSchemeCode()
    {
        return (ID)super.getData(XON.POSITION_ID_CHECK_DIGIT_SCHEME_CODE);
    }

    /**
     * Component 5
     */
    public void setIDCheckDigitSchemeCode(ID idCheckDigitSchemeCode)
    {
        super
            .setData(XON.POSITION_ID_CHECK_DIGIT_SCHEME_CODE, idCheckDigitSchemeCode);
    }

    /**
     * Component 6
     */
    public HD getAssigningAuthority()
    {
        return (HD)super.getData(XON.POSITION_ASSIGNING_AUTHORITY);
    }

    /**
     * Component 6
     */
    public void setAssigningAuthority(HD assigningAuthority)
    {
        super.setData(XON.POSITION_ASSIGNING_AUTHORITY, assigningAuthority);
    }

    /**
     * Component 7
     */
    public IS getIDTypeCode()
    {
        return (IS)super.getData(XON.POSITION_ID_TYPE_CODE);
    }

    /**
     * Component 7
     */
    public void setIDTypeCode(IS idTypeCode)
    {
        super.setData(XON.POSITION_ID_TYPE_CODE, idTypeCode);
    }

    /**
     * Component 8
     */
    public HD getAssigningFacility()
    {
        return (HD)super.getData(XON.POSITION_ASSIGNING_FACILITY);
    }

    /**
     * Component 8
     */
    public void setAssigningFacility(HD assigningFacility)
    {
        super.setData(XON.POSITION_ASSIGNING_FACILITY, assigningFacility);
    }

    /**
     * Component 9
     */
    public ID getRepresentationCode()
    {
        return (ID)super.getData(XON.POSITION_REPRESENTATION_CODE);
    }

    /**
     * Component 9
     */
    public void setRepresentationCode(ID representationCode)
    {
        super.setData(XON.POSITION_REPRESENTATION_CODE, representationCode);
    }
}