/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class XCN
    extends ComplexTypeMetaData
{
    private static final int POSITION_ID = 0;
    private static final int POSITION_FAMILY_NAME = 1;
    private static final int POSITION_GIVEN_NAME = 2;
    private static final int POSITION_MIDDLE_NAME = 3;
    private static final int POSITION_SUFFIX = 4;
    private static final int POSITION_PREFIX = 5;
    private static final int POSITION_DEGREE = 6;
    private static final int POSITION_SOURCE_TABLE = 7;
    private static final int POSITION_ASSIGNING_AUTHORITY = 8;
    private static final int POSITION_TYPE_CODE = 9;
    private static final int POSITION_ID_CHECK_DIGIT = 10;
    private static final int POSITION_ID_CHECK_DIGIT_SCHEME_CODE = 11;
    private static final int POSITION_ID_TYPE_CODE = 12;
    private static final int POSITION_ASSIGNING_FACILITY = 13;
    private static final int POSITION_REPRESENTATION_CODE = 14;
    private static final int DATA_SIZE = 15;

    public static XCN[] create(
        String value,
        String repeatDelimiter,
        String delimiter,
        String subDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData
                .splitData(value, repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            XCN[] elements = new XCN[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = XCN
                    .create(components[index], delimiter, subDelimiter);
            }

            return elements;
        }
    }

    public static XCN create()
    {
        return new XCN(new AbstractDataTypeMetaData[XCN.DATA_SIZE]);
    }

    public static XCN create(String value, String delimiter, String subDelimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[XCN.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData
                .splitData(value, delimiter);
            int size = (components == null) ? 0 : components.length;

            data[XCN.POSITION_ID] = (size > XCN.POSITION_ID) ? ST
                .create(components[XCN.POSITION_ID]) : null;
            data[XCN.POSITION_FAMILY_NAME] = (size > XCN.POSITION_FAMILY_NAME) ? ST
                .create(components[XCN.POSITION_FAMILY_NAME])
                : null;
            data[XCN.POSITION_GIVEN_NAME] = (size > XCN.POSITION_GIVEN_NAME) ? ST
                .create(components[XCN.POSITION_GIVEN_NAME])
                : null;
            data[XCN.POSITION_MIDDLE_NAME] = (size > XCN.POSITION_MIDDLE_NAME) ? ST
                .create(components[XCN.POSITION_MIDDLE_NAME])
                : null;
            data[XCN.POSITION_SUFFIX] = (size > XCN.POSITION_SUFFIX) ? ST
                .create(components[XCN.POSITION_SUFFIX]) : null;
            data[XCN.POSITION_PREFIX] = (size > XCN.POSITION_PREFIX) ? ST
                .create(components[XCN.POSITION_PREFIX]) : null;
            data[XCN.POSITION_DEGREE] = (size > XCN.POSITION_DEGREE) ? IS
                .create(components[XCN.POSITION_DEGREE]) : null;
            data[XCN.POSITION_SOURCE_TABLE] = (size > XCN.POSITION_SOURCE_TABLE) ? IS
                .create(components[XCN.POSITION_SOURCE_TABLE])
                : null;
            data[XCN.POSITION_ASSIGNING_AUTHORITY] = (size > XCN.POSITION_ASSIGNING_AUTHORITY) ? HD
                .create(components[XCN.POSITION_ASSIGNING_AUTHORITY], subDelimiter)
                : null;
            data[XCN.POSITION_TYPE_CODE] = (size > XCN.POSITION_TYPE_CODE) ? ID
                .create(components[XCN.POSITION_TYPE_CODE]) : null;
            data[XCN.POSITION_ID_CHECK_DIGIT] = (size > XCN.POSITION_ID_CHECK_DIGIT) ? ST
                .create(components[XCN.POSITION_ID_CHECK_DIGIT])
                : null;
            data[XCN.POSITION_ID_CHECK_DIGIT_SCHEME_CODE] = (size > XCN.POSITION_ID_CHECK_DIGIT_SCHEME_CODE) ? ID
                .create(components[XCN.POSITION_ID_CHECK_DIGIT_SCHEME_CODE])
                : null;
            data[XCN.POSITION_ID_TYPE_CODE] = (size > XCN.POSITION_ID_TYPE_CODE) ? IS
                .create(components[XCN.POSITION_ID_TYPE_CODE])
                : null;
            data[XCN.POSITION_ASSIGNING_FACILITY] = (size > XCN.POSITION_ASSIGNING_FACILITY) ? HD
                .create(components[XCN.POSITION_ASSIGNING_FACILITY], subDelimiter)
                : null;
            data[XCN.POSITION_REPRESENTATION_CODE] = (size > XCN.POSITION_REPRESENTATION_CODE) ? ID
                .create(components[XCN.POSITION_REPRESENTATION_CODE])
                : null;

            return new XCN(data);
        }
    }

    public static String getDataString(
        XCN[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData
            .formatDataString(data, repeatDelimiter, delimiter, null);
    }

    XCN(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getID()
    {
        return (ST)super.getData(XCN.POSITION_ID);
    }

    /**
     * Component 1
     */
    public void setID(ST id)
    {
        super.setData(XCN.POSITION_ID, id);
    }

    /**
     * Component 2
     */
    public ST getFamilyName()
    {
        return (ST)super.getData(XCN.POSITION_FAMILY_NAME);
    }

    /**
     * Component 2
     */
    public void setFamilyName(ST familyName)
    {
        super.setData(XCN.POSITION_FAMILY_NAME, familyName);
    }

    /**
     * Component 3
     */
    public ST getGivenName()
    {
        return (ST)super.getData(XCN.POSITION_GIVEN_NAME);
    }

    /**
     * Component 3
     */
    public void setGivenName(ST givenName)
    {
        super.setData(XCN.POSITION_GIVEN_NAME, givenName);
    }

    /**
     * Component 4
     */
    public ST getMiddleName()
    {
        return (ST)super.getData(XCN.POSITION_MIDDLE_NAME);
    }

    /**
     * Component 4
     */
    public void setMiddleName(ST middleName)
    {
        super.setData(XCN.POSITION_MIDDLE_NAME, middleName);
    }

    /**
     * Component 5
     */
    public ST getSuffix()
    {
        return (ST)super.getData(XCN.POSITION_SUFFIX);
    }

    /**
     * Component 5
     */
    public void setSuffix(ST suffix)
    {
        super.setData(XCN.POSITION_SUFFIX, suffix);
    }

    /**
     * Component 6
     */
    public ST getPrefix()
    {
        return (ST)super.getData(XCN.POSITION_PREFIX);
    }

    /**
     * Component 6
     */
    public void setPrefix(ST prefix)
    {
        super.setData(XCN.POSITION_PREFIX, prefix);
    }

    /**
     * Component 7
     */
    public IS getDegree()
    {
        return (IS)super.getData(XCN.POSITION_DEGREE);
    }

    /**
     * Component 7
     */
    public void setDegree(IS degree)
    {
        super.setData(XCN.POSITION_DEGREE, degree);
    }

    /**
     * Component 8
     */
    public IS getSourceTable()
    {
        return (IS)super.getData(XCN.POSITION_SOURCE_TABLE);
    }

    /**
     * Component 8
     */
    public void setSourceTable(IS sourceTable)
    {
        super.setData(XCN.POSITION_SOURCE_TABLE, sourceTable);
    }

    /**
     * Component 9
     */
    public HD getAssigningAuthority()
    {
        return (HD)super.getData(XCN.POSITION_ASSIGNING_AUTHORITY);
    }

    /**
     * Component 9
     */
    public void setAssigningAuthority(HD assigningAuthority)
    {
        super.setData(XCN.POSITION_ASSIGNING_AUTHORITY, assigningAuthority);
    }

    /**
     * Component 10
     */
    public ID getTypeCode()
    {
        return (ID)super.getData(XCN.POSITION_TYPE_CODE);
    }

    /**
     * Component 10
     */
    public void setTypeCode(ID typeCode)
    {
        super.setData(XCN.POSITION_TYPE_CODE, typeCode);
    }

    /**
     * Component 11
     */
    public ST getIDCheckDigit()
    {
        return (ST)super.getData(XCN.POSITION_ID_CHECK_DIGIT);
    }

    /**
     * Component 11
     */
    public void setIDCheckDigit(ST idCheckDigit)
    {
        super.setData(XCN.POSITION_ID_CHECK_DIGIT, idCheckDigit);
    }

    /**
     * Component 12
     */
    public ID getIDCheckDigitSchemeCode()
    {
        return (ID)super.getData(XCN.POSITION_ID_CHECK_DIGIT_SCHEME_CODE);
    }

    /**
     * Component 12
     */
    public void setIDCheckDigitSchemeCode(ID idCheckDigitSchemeCode)
    {
        super
            .setData(XCN.POSITION_ID_CHECK_DIGIT_SCHEME_CODE, idCheckDigitSchemeCode);
    }

    /**
     * Component 13
     */
    public IS getIDTypeCode()
    {
        return (IS)super.getData(XCN.POSITION_ID_TYPE_CODE);
    }

    /**
     * Component 13
     */
    public void setIDTypeCode(IS idTypeCode)
    {
        super.setData(XCN.POSITION_ID_TYPE_CODE, idTypeCode);
    }

    /**
     * Component 14
     */
    public HD getAssigningFacility()
    {
        return (HD)super.getData(XCN.POSITION_ASSIGNING_FACILITY);
    }

    /**
     * Component 14
     */
    public void setAssigningFacility(HD assigningFacility)
    {
        super.setData(XCN.POSITION_ASSIGNING_FACILITY, assigningFacility);
    }

    /**
     * Component 15
     */
    public ID getRepresentationCode()
    {
        return (ID)super.getData(XCN.POSITION_REPRESENTATION_CODE);
    }

    /**
     * Component 15
     */
    public void setRepresentationCode(ID representationCode)
    {
        super.setData(XCN.POSITION_REPRESENTATION_CODE, representationCode);
    }
}