/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class XAD
    extends ComplexTypeMetaData
{
    public static final String START_AND_END_DATE_DELIMITER = "&";
    
    private static final int POSITION_STREET_ADDRESS = 0;
    private static final int POSITION_OTHER_DESIGNATION = 1;
    private static final int POSITION_CITY = 2;
    private static final int POSITION_STATE = 3;
    private static final int POSITION_ZIP_CODE = 4;
    private static final int POSITION_COUNTRY_CODE = 5;
    private static final int POSITION_TYPE_CODE = 6;
    private static final int POSITION_OTHER_GEOGRAPHIC_DESIGNATION = 7;
    private static final int POSITION_COUNTY_PARISH_CODE = 8;
    private static final int POSITION_CENSUS_TRACT = 9;
    private static final int POSITION_REPRESENTATION_CODE = 10;
    private static final int POSITION_ADDRESS_VALIDITY_RANGE = 11;
    private static final int DATA_SIZE = 12;

    public static XAD[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            XAD[] elements = new XAD[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = XAD.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static XAD create()
    {
        return new XAD(new AbstractDataTypeMetaData[XAD.DATA_SIZE]);
    }

    public static XAD create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[XAD.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData.splitData(value,
                delimiter);
            int size = (components == null) ? 0 : components.length;

            data[XAD.POSITION_STREET_ADDRESS] = (size > XAD.POSITION_STREET_ADDRESS) ? ST
                .create(components[XAD.POSITION_STREET_ADDRESS])
                : null;
            data[XAD.POSITION_OTHER_DESIGNATION] = (size > XAD.POSITION_OTHER_DESIGNATION) ? ST
                .create(components[XAD.POSITION_OTHER_DESIGNATION])
                : null;
            data[XAD.POSITION_CITY] = (size > XAD.POSITION_CITY) ? ST
                .create(components[XAD.POSITION_CITY]) : null;
            data[XAD.POSITION_STATE] = (size > XAD.POSITION_STATE) ? ST
                .create(components[XAD.POSITION_STATE]) : null;
            data[XAD.POSITION_ZIP_CODE] = (size > XAD.POSITION_ZIP_CODE) ? ST
                .create(components[XAD.POSITION_ZIP_CODE]) : null;
            data[XAD.POSITION_COUNTRY_CODE] = (size > XAD.POSITION_COUNTRY_CODE) ? ID
                .create(components[XAD.POSITION_COUNTRY_CODE])
                : null;
            data[XAD.POSITION_TYPE_CODE] = (size > XAD.POSITION_TYPE_CODE) ? ID
                .create(components[XAD.POSITION_TYPE_CODE]) : null;
            data[XAD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION] = (size > XAD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION) ? ST
                .create(components[XAD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION])
                : null;
            data[XAD.POSITION_COUNTY_PARISH_CODE] = (size > XAD.POSITION_COUNTY_PARISH_CODE) ? IS
                .create(components[XAD.POSITION_COUNTY_PARISH_CODE])
                : null;
            data[XAD.POSITION_CENSUS_TRACT] = (size > XAD.POSITION_CENSUS_TRACT) ? IS
                .create(components[XAD.POSITION_CENSUS_TRACT])
                : null;
            data[XAD.POSITION_REPRESENTATION_CODE] = (size > XAD.POSITION_REPRESENTATION_CODE) ? ID
                .create(components[XAD.POSITION_REPRESENTATION_CODE])
                : null;
            data[XAD.POSITION_ADDRESS_VALIDITY_RANGE] = (size > XAD.POSITION_ADDRESS_VALIDITY_RANGE) ? ST
                        .create(components[XAD.POSITION_ADDRESS_VALIDITY_RANGE])
                        : null;

            return new XAD(data);
        }
    }

    public static String getDataString(
        XAD[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            delimiter, null);
    }

    XAD(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getStreetAddress()
    {
        return (ST)super.getData(XAD.POSITION_STREET_ADDRESS);
    }

    /**
     * Component 1
     */
    public void setStreetAddress(ST streetAddress)
    {
        super.setData(XAD.POSITION_STREET_ADDRESS, streetAddress);
    }

    /**
     * Component 2
     */
    public ST getOtherDesignation()
    {
        return (ST)super.getData(XAD.POSITION_OTHER_DESIGNATION);
    }

    /**
     * Component 2
     */
    public void setOtherDesignation(ST otherDesignation)
    {
        super.setData(XAD.POSITION_OTHER_DESIGNATION, otherDesignation);
    }

    /**
     * Component 3
     */
    public ST getCity()
    {
        return (ST)super.getData(XAD.POSITION_CITY);
    }

    /**
     * Component 3
     */
    public void setCity(ST city)
    {
        super.setData(XAD.POSITION_CITY, city);
    }

    /**
     * Component 4
     */
    public ST getState()
    {
        return (ST)super.getData(XAD.POSITION_STATE);
    }

    /**
     * Component 4
     */
    public void setState(ST state)
    {
        super.setData(XAD.POSITION_STATE, state);
    }

    /**
     * Component 5
     */
    public ST getZipCode()
    {
        return (ST)super.getData(XAD.POSITION_ZIP_CODE);
    }

    /**
     * Component 5
     */
    public void setZipCode(ST zipCode)
    {
        super.setData(XAD.POSITION_ZIP_CODE, zipCode);
    }

    /**
     * Component 6
     */
    public ID getCountryCode()
    {
        return (ID)super.getData(XAD.POSITION_COUNTRY_CODE);
    }

    /**
     * Component 6
     */
    public void setCountryCode(ID countryCode)
    {
        super.setData(XAD.POSITION_COUNTRY_CODE, countryCode);
    }

    /**
     * Component 7
     */
    public ID getTypeCode()
    {
        return (ID)super.getData(XAD.POSITION_TYPE_CODE);
    }

    /**
     * Component 7
     */
    public void setTypeCode(ID typeCode)
    {
        super.setData(XAD.POSITION_TYPE_CODE, typeCode);
    }

    /**
     * Component 8
     */
    public ST getOtherGeographicDesignation()
    {
        return (ST)super.getData(XAD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION);
    }

    /**
     * Component 8
     */
    public void setOtherGeographicDesignation(ST otherGeographicDesignation)
    {
        super.setData(XAD.POSITION_OTHER_GEOGRAPHIC_DESIGNATION,
            otherGeographicDesignation);
    }

    /**
     * Component 9
     */
    public IS getCountyParishCode()
    {
        return (IS)super.getData(XAD.POSITION_COUNTY_PARISH_CODE);
    }

    /**
     * Component 9
     */
    public void setCountyParishCode(IS countyParishCode)
    {
        super.setData(XAD.POSITION_COUNTY_PARISH_CODE, countyParishCode);
    }

    /**
     * Component 10
     */
    public IS getCensusTract()
    {
        return (IS)super.getData(XAD.POSITION_CENSUS_TRACT);
    }

    /**
     * Component 10
     */
    public void setCensusTract(IS censusTract)
    {
        super.setData(XAD.POSITION_CENSUS_TRACT, censusTract);
    }

    /**
     * Component 11
     */
    public ID getRepresentationCode()
    {
        return (ID)super.getData(XAD.POSITION_REPRESENTATION_CODE);
    }

    /**
     * Component 11
     */
    public void setRepresentationCode(ID representationCode)
    {
        super.setData(XAD.POSITION_REPRESENTATION_CODE, representationCode);
    }

    /**
     * Component 12 Start Date and End Date delimited by a ampersand(&)
     * e.g 20050808&20050818
     */
    public void setAddressValidityRange(ST addressValidityRange)
    {
        super.setData(XAD.POSITION_ADDRESS_VALIDITY_RANGE,
            addressValidityRange);
    }    

    /**
     * Component 12 Start Date and End Date delimited by a ampersand(&)
     * e.g 20050808&20050818
     */
    public ST getAddressValidityRange()
    {
        return (ST)super.getData((XAD.POSITION_ADDRESS_VALIDITY_RANGE));
    }
    
    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}