/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

//Java Classes

//Library Classes

//Framework Classes

//Common Classes

//Messaging Classes

/**
 * @author Martin Francisco
 */
public class TS
    extends ComplexTypeMetaData
{
    private static final int POSITION_DATETIME = 0;
    private static final int POSITION_PRECISION = 1;
    private static final int DATA_SIZE = 2;

    public static TS[] create(
        String value,
        String repeatDelimiter,
        String delimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData
                .splitData(value, repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            TS[] elements = new TS[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = TS.create(components[index], delimiter);
            }

            return elements;
        }
    }

    public static TS create()
    {
        return new TS(new AbstractDataTypeMetaData[TS.DATA_SIZE]);
    }

    public static TS create(String value, String delimiter)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[TS.DATA_SIZE];

            String[] components = AbstractDataTypeMetaData
                .splitData(value, delimiter);
            int size = (components == null) ? 0 : components.length;

            data[TS.POSITION_DATETIME] = (size > TS.POSITION_DATETIME) ? ST
                .create(components[TS.POSITION_DATETIME]) : null;
            data[TS.POSITION_PRECISION] = (size > TS.POSITION_PRECISION) ? ST
                .create(components[TS.POSITION_PRECISION]) : null;

            return new TS(data);
        }
    }

    public static String getDataString(
        TS[] data,
        String repeatDelimiter,
        String delimiter)
    {
        return AbstractDataTypeMetaData
            .formatDataString(data, repeatDelimiter, delimiter, null);
    }

    TS(AbstractDataTypeMetaData[] data)
    {
        super(data);
    }

    /**
     * Component 1
     */
    public ST getDateTime()
    {
        return (ST)super.getData(TS.POSITION_DATETIME);
    }

    /**
     * Component 1
     */
    public void setDateTime(ST dateTime)
    {
        super.setData(TS.POSITION_DATETIME, dateTime);
    }

    /**
     * Component 2
     */
    public ST getPrecision()
    {
        return (ST)super.getData(TS.POSITION_PRECISION);
    }

    /**
     * Component 2
     */
    public void setPrecision(ST precision)
    {
        super.setData(TS.POSITION_PRECISION, precision);
    }

    public final String getDataString(String delimiter)
    {
        return super.getDataString(delimiter, null);
    }
}