/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class TN
    extends SimpleTypeMetaData
{
    public static TN[] create(String value, String repeatDelimiter)
    {
        if(value == null)
        {
            return null;
        }
        else
        {
            String[] components = AbstractDataTypeMetaData.splitData(value,
                repeatDelimiter);
            int size = (components == null) ? 0 : components.length;

            TN[] elements = new TN[size];

            for(int index = 0; index < size; index++)
            {
                elements[index] = TN.create(components[index]);
            }

            return elements;
        }
    }

    public static TN create(String value)
    {
        if(AbstractDataTypeMetaData.shouldDelete(value))
        {
            return null;
        }
        else
        {
            return new TN(value);
        }
    }

    public static String getDataString(TN[] data, String repeatDelimiter)
    {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter,
            null, null);
    }

    TN(String value)
    {
        super(value);
    }
}