/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.builder.datatype.metadata;

// Java Classes

// Library Classes
import org.apache.commons.lang.Validate;

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public abstract class SimpleTypeMetaData
    extends AbstractDataTypeMetaData
{
    private String value;

    protected SimpleTypeMetaData(String value)
    {
        super();
        Validate.notNull(value, "value cannot be null");
        this.value = value;
    }

    public final String getDataString()
    {
        return this.getDataString(null, null);
    }

    public final String getDataString(String delimiter, String subDelimiter)
    {
        return this.value;
    }

    /**
     * @return Returns the value.
     */
    public String getValue()
    {
        return this.value;
    }
}